/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.crypto.vhsm.engine.key;

import com.xdja.alg.SM2PrivateKey;
import com.xdja.alg.SM2PublicKey;
import com.xdja.alg.XdjaCryptoEx;
import com.xdja.jce.base.ec.ECNamedCurveTable;
import com.xdja.jce.base.key.ECKeyFactoryEngine;
import com.xdja.jce.base.spec.ECNamedCurveParameterSpec;
import com.xdja.jce.base.spec.ECParameterSpec;
import com.xdja.jce.base.spec.ECPrivateKeySpec;
import com.xdja.jce.base.spec.ECPublicKeySpec;
import com.xdja.jce.crypto.vhsm.engine.SM2Init;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.KeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2KeyPairGeneratorEngine
extends KeyPairGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SM2KeyPairGeneratorEngine() {
        super("EC");
        new SM2Init();
    }

    @Override
    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        SM2PublicKey sm2PublicKey = new SM2PublicKey();
        SM2PrivateKey sm2PrivateKey = new SM2PrivateKey();
        boolean flag = XdjaCryptoEx.getInstance().sm2Genkey(sm2PublicKey, sm2PrivateKey);
        if (!flag) {
            this.logger.error("VHSM--\u751f\u6210SM2\u5bc6\u94a5\u5bf9\u5931\u8d25\uff01\u9519\u8bef\u7801\uff1a" + XdjaCryptoEx.getInstance().getErrorCode());
        }
        try {
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(1, sm2PrivateKey.d), (ECParameterSpec)spec);
            ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(spec.getCurve().createPoint(new BigInteger(1, sm2PublicKey.x), new BigInteger(1, sm2PublicKey.y)), (ECParameterSpec)spec);
            ECKeyFactoryEngine.ECEngine factory = new ECKeyFactoryEngine.ECEngine();
            keyPair = new KeyPair(factory.engineGeneratePublic((KeySpec)publicKeySpec), factory.engineGeneratePrivate((KeySpec)privateKeySpec));
        }
        catch (Exception e) {
            this.logger.error("VHSM--\u6784\u9020SM2\u5bc6\u94a5\u5bf9\u5f02\u5e38");
            e.printStackTrace();
        }
        return keyPair;
    }
}

