/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.hash.engine;

import com.xdja.jce.core.util.Memoable;
import com.xdja.jce.core.util.Pack;
import com.xdja.jce.hash.digest.LongDigest;

public class SHA512Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 64;

    public SHA512Digest() {
    }

    public SHA512Digest(SHA512Digest t) {
        super(t);
    }

    public SHA512Digest(byte[] encodedState) {
        this.restoreState(encodedState);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512";
    }

    @Override
    public int getDigestSize() {
        return 64;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Pack.longToBigEndian((long)this.H1, (byte[])out, (int)outOff);
        Pack.longToBigEndian((long)this.H2, (byte[])out, (int)(outOff + 8));
        Pack.longToBigEndian((long)this.H3, (byte[])out, (int)(outOff + 16));
        Pack.longToBigEndian((long)this.H4, (byte[])out, (int)(outOff + 24));
        Pack.longToBigEndian((long)this.H5, (byte[])out, (int)(outOff + 32));
        Pack.longToBigEndian((long)this.H6, (byte[])out, (int)(outOff + 40));
        Pack.longToBigEndian((long)this.H7, (byte[])out, (int)(outOff + 48));
        Pack.longToBigEndian((long)this.H8, (byte[])out, (int)(outOff + 56));
        this.reset();
        return 64;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = 7640891576956012808L;
        this.H2 = -4942790177534073029L;
        this.H3 = 4354685564936845355L;
        this.H4 = -6534734903238641935L;
        this.H5 = 5840696475078001361L;
        this.H6 = -7276294671716946913L;
        this.H7 = 2270897969802886507L;
        this.H8 = 6620516959819538809L;
    }

    public Memoable copy() {
        return new SHA512Digest(this);
    }

    public void reset(Memoable other) {
        SHA512Digest d = (SHA512Digest)other;
        this.copyIn(d);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] encoded = new byte[this.getEncodedStateSize()];
        super.populateState(encoded);
        return encoded;
    }
}

