package com.xdja.jce.hash.digest;

import com.xdja.jce.core.provider.DeviceProvider;

/**
 * @Author:ggp
 * @Date:2021/7/9 10:48
 * @Description:
 * 装饰器模式
 * Digest是接口，为了给其增加一些属性，比如DeviceProvider
 */
public class DecoratorDigest implements Digest {
    private Digest digest;
    private DeviceProvider deviceProvider;

    public DecoratorDigest(Digest digest) {
        this.digest = digest;
    }

    @Override
    public String getAlgorithmName() {
        return digest.getAlgorithmName();
    }

    @Override
    public int getDigestSize() {
        return digest.getDigestSize();
    }

    @Override
    public void update(byte in) {
        digest.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        digest.update(in,inOff,len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return digest.doFinal(out,outOff);
    }

    @Override
    public void reset() {
        digest.reset();
    }

    public Digest getDigest() {
        return digest;
    }

    public void setDigest(Digest digest) {
        this.digest = digest;
    }

    public DeviceProvider getDeviceProvider() {
        return deviceProvider;
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }
}
