package com.xdja.jce.hash.digest;


import java.security.MessageDigest;

/**
 * 通过持有一个 Digest对象和继承MessageDigest，完成Digest子类对provider必须要实现的MessageDigestSpi进行适配
 *
 * 适配器模式~~~
 *
 * */
public class MessageDigestWrap
    extends MessageDigest
{
    protected Digest digest;
    protected int     digestSize;

    protected MessageDigestWrap(
            Digest digest)
    {
        super(digest.getAlgorithmName());

        this.digest = digest;
        this.digestSize = digest.getDigestSize();
    }

    protected MessageDigestWrap(
            Xof digest, int outputSize)
    {
        super(digest.getAlgorithmName());

        this.digest = digest;
        this.digestSize = outputSize / 8;
    }

    public void engineReset() 
    {
        digest.reset();
    }

    public void engineUpdate(
        byte    input) 
    {
        digest.update(input);
    }

    public void engineUpdate(
        byte[]  input,
        int     offset,
        int     len) 
    {
        digest.update(input, offset, len);
    }

    public int engineGetDigestLength()
    {
        return digestSize;
    }

    public byte[] engineDigest() 
    {
        byte[]  digestBytes = new byte[digestSize];

        digest.doFinal(digestBytes, 0);

        return digestBytes;
    }

    public Digest getDigest() {
        return digest;
    }
}
