package com.xdja.jce.hash.digest;

/**
 * With FIPS PUB 202 a new kind of message digest was announced which supported extendable output, or variable digest sizes.
 * This interface provides the extra method required to support variable output on an extended digest implementation.
 *
 *   在 FIPS PUB 202 中宣布了一种新的消息摘要，它支持可扩展的输出或可变的摘要大小。
 *   此接口提供了支持扩展摘要实现上的变量输出所需的额外方法。
 */
public interface Xof
    extends ExtendedDigest
{
    /**
     * Output the results of the final calculation for this digest to outLen number of bytes.
     *
     * @param out output array to write the output bytes to.
     * @param outOff offset to start writing the bytes at.
     * @param outLen the number of output bytes requested.
     * @return the number of bytes written
     */
    int doFinal(byte[] out, int outOff, int outLen);

    /**
     * Start outputting the results of the final calculation for this digest. Unlike doFinal, this method
     * will continue producing output until the Xof is explicitly reset, or signals otherwise.
     *
     * @param out output array to write the output bytes to.
     * @param outOff offset to start writing the bytes at.
     * @param outLen the number of output bytes requested.
     * @return the number of bytes written
     */
    int doOutput(byte[] out, int outOff, int outLen);
}
