/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.provider.agent.asymmetric;

import com.xdja.jce.base.cipher.asymmetric.GMCipherSpi;
import com.xdja.jce.base.cipher.asymmetric.GMSignatureSpi;
import com.xdja.jce.base.provider.config.AsymmetricAlgorithmProvider;
import com.xdja.jce.base.provider.config.ConfigurableProvider;
import com.xdja.jce.base.provider.config.GetInstance;
import com.xdja.jce.coding.asn1.gm.GMObjectIdentifiers;
import java.util.HashMap;
import java.util.Map;

public class SM2 {
    private static final String ALG_NAME = "SM2";
    private static final Map<String, String> generalSm2Attributes = new HashMap<String, String>();

    static {
        generalSm2Attributes.put("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey");
        generalSm2Attributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        private static final String PREFIX = SM2.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Signature.SM3WITHSM2", PREFIX + "$sm3WithSM2");
            provider.addAlgorithm("Alg.Alias.Signature." + GMObjectIdentifiers.sm2sign_with_sm3, "SM3WITHSM2");
            provider.addAlgorithm("Cipher.SM2", PREFIX + "$Cipher");
            provider.addAlgorithm("Alg.Alias.Cipher.SM2WITHSM3", SM2.ALG_NAME);
            provider.addAlgorithm("Alg.Alias.Cipher." + GMObjectIdentifiers.sm2encrypt_with_sm3, SM2.ALG_NAME);
        }
    }

    public static class sm3WithSM2
    extends GMSignatureSpi {
        public sm3WithSM2() {
            super("SM3WITHSM2", GetInstance.getGmSignerEngineInstance((String)"SM3WITHSM2"));
        }
    }

    public static class Cipher
    extends GMCipherSpi {
        public Cipher() {
            super(GetInstance.getGmCipherEngineInstance((String)SM2.ALG_NAME));
        }
    }
}

