/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.provider.agent.digest;

import com.xdja.jce.base.cipher.BaseMac;
import com.xdja.jce.base.generators.CipherKeyGenerator;
import com.xdja.jce.base.key.BaseKeyGenerator;
import com.xdja.jce.base.mac.HMac;
import com.xdja.jce.base.mac.Mac;
import com.xdja.jce.base.provider.config.ConfigurableProvider;
import com.xdja.jce.base.provider.config.DigestAlgorithmProvider;
import com.xdja.jce.base.provider.config.GetInstance;
import com.xdja.jce.coding.asn1.gm.GMObjectIdentifiers;
import com.xdja.jce.hash.digest.MessageDigestWrap;

public class SM3 {
    private static final String ALG_NAME = "SM3";

    private SM3() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SM3.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SM3", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SM3", SM3.ALG_NAME);
            provider.addAlgorithm("Alg.Alias.MessageDigest.1.2.156.197.1.401", SM3.ALG_NAME);
            provider.addAlgorithm("Alg.Alias.MessageDigest." + GMObjectIdentifiers.sm3, SM3.ALG_NAME);
            this.addHMACAlgorithm(provider, SM3.ALG_NAME, PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSM3", 256, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super((Mac)new HMac(GetInstance.getDigestEngineInstance((String)SM3.ALG_NAME)));
        }
    }

    public static class Digest
    extends MessageDigestWrap
    implements Cloneable {
        public Digest() {
            super(GetInstance.getDigestEngineInstance((String)SM3.ALG_NAME));
        }
    }
}

