/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.provider.agent.symmetric;

import com.xdja.jce.base.cipher.BaseBlockCipher;
import com.xdja.jce.base.cipher.BlockCipher;
import com.xdja.jce.base.cipher.BlockCipherProvider;
import com.xdja.jce.base.common.BaseAlgorithmParameterGenerator;
import com.xdja.jce.base.common.CryptoServicesRegistrar;
import com.xdja.jce.base.generators.CipherKeyGenerator;
import com.xdja.jce.base.key.BaseKeyGenerator;
import com.xdja.jce.base.params.IvAlgorithmParameters;
import com.xdja.jce.base.provider.config.ConfigurableProvider;
import com.xdja.jce.base.provider.config.GetInstance;
import com.xdja.jce.base.provider.config.SymmetricAlgorithmProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SM4 {
    private static final String ALG_NAME = "SM4";

    private SM4() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = SM4.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.SM4", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.SM4", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Cipher.SM4", PREFIX + "$Cipher");
            provider.addAlgorithm("KeyGenerator.SM4", PREFIX + "$KeyGen");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "SM4 IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SM4 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance(SM4.ALG_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super(SM4.ALG_NAME, 128, null == GetInstance.getSymmetricKeyInstance((String)SM4.ALG_NAME) ? new CipherKeyGenerator() : GetInstance.getSymmetricKeyInstance((String)SM4.ALG_NAME));
        }
    }

    public static class Cipher
    extends BaseBlockCipher {
        public Cipher() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return GetInstance.getSymmetricCipherEngineInstance((String)SM4.ALG_NAME);
                }
            });
        }
    }
}

