/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.provider.agent.symmetric;

import com.xdja.jce.base.cipher.BaseBlockCipher;
import com.xdja.jce.base.cipher.BlockCipher;
import com.xdja.jce.base.cipher.BlockCipherProvider;
import com.xdja.jce.base.generators.CipherKeyGenerator;
import com.xdja.jce.base.key.BaseKeyGenerator;
import com.xdja.jce.base.key.PBESecretKeyFactory;
import com.xdja.jce.base.modes.CBCBlockCipher;
import com.xdja.jce.base.params.IvAlgorithmParameters;
import com.xdja.jce.base.provider.config.ConfigurableProvider;
import com.xdja.jce.base.provider.config.GetInstance;
import com.xdja.jce.base.provider.config.SymmetricAlgorithmProvider;

public final class Twofish {
    private static final String ALG_NAME = "Twofish";

    private Twofish() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Twofish.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Twofish", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.Twofish", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.Twofish", PREFIX + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
            provider.addAlgorithm("Cipher.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHA");
            provider.addAlgorithm("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHAKeyFactory");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Twofish IV";
        }
    }

    public static class PBEWithSHA
    extends BaseBlockCipher {
        public PBEWithSHA() {
            super((BlockCipher)new CBCBlockCipher(GetInstance.getSymmetricCipherEngineInstance((String)Twofish.ALG_NAME)), 2, 1, 256, 16);
        }
    }

    public static class PBEWithSHAKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHAKeyFactory() {
            super("PBEwithSHAandTwofish-CBC", null, true, 2, 1, 256, 128);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super(Twofish.ALG_NAME, 256, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return GetInstance.getSymmetricCipherEngineInstance((String)Twofish.ALG_NAME);
                }
            });
        }
    }
}

