/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.provider.agent.asymmetric;

import com.xdja.jce.base.cipher.AsymmetricCipher;
import com.xdja.jce.base.cipher.asymmetric.KeyFactoryWrap;
import com.xdja.jce.base.cipher.asymmetric.KeyPairGeneratorWrap;
import com.xdja.jce.base.encodings.PKCS1Encoding;
import com.xdja.jce.base.generators.CipherKeyGenerator;
import com.xdja.jce.base.gm.GMObjectIdentifiers;
import com.xdja.jce.base.key.BaseKeyGenerator;
import com.xdja.jce.base.provider.config.AsymmetricAlgorithmProvider;
import com.xdja.jce.base.provider.config.AsymmetricKeyInfoConverter;
import com.xdja.jce.base.provider.config.ConfigurableProvider;
import com.xdja.jce.base.provider.config.GetInstance;
import com.xdja.jce.base.rsa.CipherSpi;
import com.xdja.jce.base.rsa.KeyFactorySpi;
import com.xdja.jce.base.signers.DigestSignatureSpi;
import com.xdja.jce.coding.asn1.ASN1ObjectIdentifier;
import com.xdja.jce.coding.asn1.nist.NISTObjectIdentifiers;
import com.xdja.jce.coding.asn1.oiw.OIWObjectIdentifiers;
import com.xdja.jce.coding.asn1.pkcs.PKCSObjectIdentifiers;
import com.xdja.jce.coding.asn1.x509.X509ObjectIdentifiers;
import java.util.HashMap;
import java.util.Map;

public class RSA {
    private static final Map<String, String> generalRsaAttributes = new HashMap<String, String>();

    static {
        generalRsaAttributes.put("SupportedKeyClasses", "javax.crypto.interfaces.RSAPublicKey|javax.crypto.interfaces.RSAPrivateKey");
        generalRsaAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        private static final String PREFIX = RSA.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAttributes("Cipher.RSA", generalRsaAttributes);
            provider.addAlgorithm("Cipher.RSA", PREFIX + "$RSACipher");
            provider.addAlgorithm("Alg.Alias.Cipher.RSA//RAW", "RSA");
            provider.addAlgorithm("Alg.Alias.Cipher.RSA//NOPADDING", "RSA");
            provider.addAlgorithm("KeyFactory.RSA", PREFIX + "$RSAKeyFactory");
            provider.addAlgorithm("KeyPairGenerator.RSA", PREFIX + "$RSAKeypairGenerator");
            provider.addAlgorithm("KeyGenerator.RSA", PREFIX + "$KeyGen");
            KeyFactorySpi keyFact = new KeyFactorySpi();
            this.registerOid(provider, PKCSObjectIdentifiers.rsaEncryption, "RSA", (AsymmetricKeyInfoConverter)keyFact);
            this.registerOid(provider, X509ObjectIdentifiers.id_ea_rsa, "RSA", (AsymmetricKeyInfoConverter)keyFact);
            this.registerOid(provider, PKCSObjectIdentifiers.id_RSAES_OAEP, "RSA", (AsymmetricKeyInfoConverter)keyFact);
            this.registerOid(provider, PKCSObjectIdentifiers.id_RSASSA_PSS, "RSA", (AsymmetricKeyInfoConverter)keyFact);
            this.registerOidAlgorithmParameters(provider, PKCSObjectIdentifiers.rsaEncryption, "RSA");
            this.registerOidAlgorithmParameters(provider, X509ObjectIdentifiers.id_ea_rsa, "RSA");
            this.addDigestSignature(provider, "SHA1", PREFIX + "$SHA1WithRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption);
            this.addDigestSignature(provider, "SHA256", PREFIX + "$SHA256WithRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
            this.addDigestSignature(provider, "SHA512", PREFIX + "$SHA512WithRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
            this.addDigestSignature(provider, "SM3", PREFIX + "$SM3WithRSA", GMObjectIdentifiers.rsasign_with_sm3);
        }

        private void addDigestSignature(ConfigurableProvider provider, String digest, String className, ASN1ObjectIdentifier oid) {
            String mainName = digest + "WITHRSA";
            String jdk11Variation1 = digest + "withRSA";
            String jdk11Variation2 = digest + "WithRSA";
            String alias = digest + "/RSA";
            String longName = digest + "WITHRSAENCRYPTION";
            String longJdk11Variation1 = digest + "withRSAEncryption";
            String longJdk11Variation2 = digest + "WithRSAEncryption";
            provider.addAlgorithm("Signature." + mainName, className);
            provider.addAlgorithm("Alg.Alias.Signature." + jdk11Variation1, mainName);
            provider.addAlgorithm("Alg.Alias.Signature." + jdk11Variation2, mainName);
            provider.addAlgorithm("Alg.Alias.Signature." + longName, mainName);
            provider.addAlgorithm("Alg.Alias.Signature." + longJdk11Variation1, mainName);
            provider.addAlgorithm("Alg.Alias.Signature." + longJdk11Variation2, mainName);
            provider.addAlgorithm("Alg.Alias.Signature." + alias, mainName);
            if (oid != null) {
                provider.addAlgorithm("Alg.Alias.Signature." + oid, mainName);
                provider.addAlgorithm("Alg.Alias.Signature.OID." + oid, mainName);
            }
        }
    }

    public static class SHA512WithRSA
    extends DigestSignatureSpi {
        public SHA512WithRSA() {
            super(NISTObjectIdentifiers.id_sha512, GetInstance.getDigestEngineInstance((String)"SHA512"), (AsymmetricCipher)new PKCS1Encoding(GetInstance.getAsymmetricCipherEngineInstance((String)"RSA")));
        }
    }

    public static class SM3WithRSA
    extends DigestSignatureSpi {
        public SM3WithRSA() {
            super(GMObjectIdentifiers.sm3, GetInstance.getDigestEngineInstance((String)"SM3"), (AsymmetricCipher)new PKCS1Encoding(GetInstance.getAsymmetricCipherEngineInstance((String)"RSA")));
        }
    }

    public static class SHA256WithRSA
    extends DigestSignatureSpi {
        public SHA256WithRSA() {
            super(NISTObjectIdentifiers.id_sha256, GetInstance.getDigestEngineInstance((String)"SHA256"), (AsymmetricCipher)new PKCS1Encoding(GetInstance.getAsymmetricCipherEngineInstance((String)"RSA")));
        }
    }

    public static class SHA1WithRSA
    extends DigestSignatureSpi {
        public SHA1WithRSA() {
            super(OIWObjectIdentifiers.idSHA1, GetInstance.getDigestEngineInstance((String)"SHA-1"), (AsymmetricCipher)new PKCS1Encoding(GetInstance.getAsymmetricCipherEngineInstance((String)"RSA")));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("RSA", 128, null == GetInstance.getSymmetricKeyInstance((String)"RSA") ? new CipherKeyGenerator() : GetInstance.getSymmetricKeyInstance((String)"RSA"));
        }
    }

    public static class RSAKeyFactory
    extends KeyFactoryWrap {
        public RSAKeyFactory() {
            super(GetInstance.getKeyFactoryEngineInstance((String)"RSA"));
        }
    }

    public static class RSAKeypairGenerator
    extends KeyPairGeneratorWrap {
        public RSAKeypairGenerator() {
            super("RSA", GetInstance.getKeyPairGeneratorEngineInstance((String)"RSA"));
        }
    }

    public static class RSACipher
    extends CipherSpi {
        public RSACipher() {
            super(GetInstance.getAsymmetricCipherEngineInstance((String)"RSA"));
        }
    }
}

