/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.provider.agent.symmetric;

import com.xdja.jce.base.cipher.BaseBlockCipher;
import com.xdja.jce.base.cipher.BlockCipher;
import com.xdja.jce.base.cipher.BlockCipherProvider;
import com.xdja.jce.base.common.BaseAlgorithmParameterGenerator;
import com.xdja.jce.base.common.CryptoServicesRegistrar;
import com.xdja.jce.base.generators.CipherKeyGenerator;
import com.xdja.jce.base.key.BaseKeyGenerator;
import com.xdja.jce.base.params.IvAlgorithmParameters;
import com.xdja.jce.base.provider.config.ConfigurableProvider;
import com.xdja.jce.base.provider.config.GetInstance;
import com.xdja.jce.base.provider.config.SymmetricAlgorithmProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class AES {
    private static final String ALG_NAME = "AES";

    private AES() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = AES.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.AES", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.AES", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Cipher.AES", PREFIX + "$Cipher");
            provider.addAlgorithm("KeyGenerator.AES", PREFIX + "$KeyGen");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "AES IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance(AES.ALG_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super(AES.ALG_NAME, 128, new CipherKeyGenerator());
        }
    }

    public static class Cipher
    extends BaseBlockCipher {
        public Cipher() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return GetInstance.getSymmetricCipherEngineInstance((String)AES.ALG_NAME);
                }
            });
        }
    }
}

