/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jprov.context;

import com.xdja.jce.base.provider.XdjaProvider;
import com.xdja.jce.base.provider.config.XdjaSecurity;
import com.xdja.jce.base.util.CertPathUtils;
import com.xdja.jce.base.util.FileUtils;
import com.xdja.jce.base.util.KeyStoreUtils;
import com.xdja.jce.logger.Logger;
import com.xdja.jce.logger.LoggerFactory;
import com.xdja.jprov.context.ProvException;
import com.xdja.jsse.provider.XdjaJsseProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ProvContext {
    private static final Logger logger;
    private SSLContext sslContext;

    public static TrustManager getTrustAllManager() {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length < 1 || authType == null || authType.length() < 1) {
                    throw new IllegalArgumentException();
                }
                String subject = chain[0].getSubjectX500Principal().getName();
                logger.info("Auto-trusted server certificate chain for: " + subject);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length < 1 || authType == null || authType.length() < 1) {
                    throw new IllegalArgumentException();
                }
                String subject = chain[0].getSubjectX500Principal().getName();
                logger.info("Auto-trusted server certificate chain for: " + subject);
            }
        };
    }

    public static ProvContext getClientInstance(String protocol) throws ProvException {
        TrustManager trustManager = ProvContext.getTrustAllManager();
        return ProvContext.getClientInstance(new TrustManager[]{trustManager}, protocol);
    }

    public static ProvContext getClientInstance(char[] password, KeyStore trustStore, String protocol) throws ProvException {
        return new ProvContext(null, password, trustStore, protocol);
    }

    public static ProvContext getClientInstance(KeyStore keyStore, char[] password, KeyStore trustStore, String protocol) throws ProvException {
        return new ProvContext(keyStore, password, trustStore, protocol);
    }

    public static ProvContext getClientInstance(TrustManager[] trustManagers, String protocol) throws ProvException {
        return new ProvContext(null, trustManagers, protocol);
    }

    public static ProvContext getServerInstance(KeyStore serverStore, char[] password, KeyStore trustStore, String protocol) throws ProvException {
        return new ProvContext(serverStore, password, trustStore, protocol);
    }

    public static ProvContext getServerInstance(KeyManager[] keyManagers, TrustManager[] trustManagers, String protocol) throws ProvException {
        return new ProvContext(keyManagers, trustManagers, protocol);
    }

    private static KeyManager[] getKeyManagers(KeyStore keyStore, char[] password) throws ProvException {
        try {
            KeyManager[] keyManagers = null;
            if (keyStore != null && password.length > 0) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX", "XDJAJSSE");
                keyManagerFactory.init(keyStore, password);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            return keyManagers;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            throw new ProvException("ProvContext get key managers exception", e);
        }
    }

    private static TrustManager[] getTrustManagers(KeyStore trustStore) throws ProvException {
        try {
            TrustManager[] trustManagers = null;
            if (trustStore != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "XDJAJSSE");
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            return trustManagers;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProvException("ProvContext get trust managers exception", e);
        }
    }

    private ProvContext(KeyStore keyStore, char[] password, KeyStore trustStore, String protocol) throws ProvException {
        this(ProvContext.getKeyManagers(keyStore, password), ProvContext.getTrustManagers(trustStore), protocol);
    }

    private ProvContext(KeyManager[] keyManagers, TrustManager[] trustManagers, String protocol) throws ProvException {
        try {
            this.sslContext = SSLContext.getInstance(protocol, "XDJAJSSE");
            this.sslContext.init(keyManagers, trustManagers, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProvException("ProvContext new instance exception", e);
        }
    }

    public SSLSocketFactory getSocketFactory() {
        return this.sslContext.getSocketFactory();
    }

    public SSLServerSocketFactory getServerSocketFactory() {
        return this.sslContext.getServerSocketFactory();
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public static KeyStore getKeystore(String path, String type, String provider, String pass) throws IOException {
        logger.debug("get key store path {}, type {}, provider {}, pass {}", new Object[]{path, type, provider, pass});
        if (path.contains(";") && path.split(";").length == 2 && pass.contains(";") && pass.split(";").length == 2) {
            String[] keys = path.split(";");
            String[] passes = pass.split(";");
            String sign = keys[0];
            String enc = keys[1];
            String signPass = passes[0];
            String encPass = passes[1];
            logger.debug("use double certificate keystore, sign is: " + sign + " pass is: " + signPass);
            logger.debug("use double certificate keystore, enc is: " + enc + " pass is: " + encPass);
            KeyStore signKeyStore = ProvContext.getStore(sign, type, provider, signPass);
            KeyStore encKeyStore = ProvContext.getStore(enc, type, provider, encPass);
            Enumeration<String> aliases = null;
            try {
                aliases = encKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!encKeyStore.isKeyEntry(alias)) continue;
                    Key key = encKeyStore.getKey(alias, encPass.toCharArray());
                    Certificate[] certificateChain = encKeyStore.getCertificateChain(alias);
                    signKeyStore.setKeyEntry(alias + "-enc", key, encPass.toCharArray(), certificateChain);
                }
            }
            catch (Exception e) {
                throw new IOException("merge keystore aliases error", e);
            }
            return signKeyStore;
        }
        return ProvContext.getStore(path, type, provider, pass);
    }

    public static KeyStore getTrustStore(String path, String type, String provider, String pass) throws IOException {
        logger.debug("get trust store path {}, type {}, provider {}, pass {}", new Object[]{path, type, provider, pass});
        KeyStore trustStore = null;
        if (path == null) {
            path = System.getProperty("javax.net.ssl.trustStore");
        }
        if (pass == null) {
            pass = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (type == null) {
            type = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (provider == null) {
            provider = System.getProperty("javax.net.ssl.trustStoreProvider");
        }
        if (CertPathUtils.checkSupportType((String)type)) {
            try {
                InputStream in = FileUtils.getResourceAsStream((String)path);
                List list = CertPathUtils.readCertificatesFromInputStream((InputStream)in);
                return KeyStoreUtils.generateGMSSLTrustStoreWithBKS((List)list);
            }
            catch (Exception e) {
                logger.error("type: {}, provider: {}, path: {}, pass: {}", new Object[]{type, provider, path, pass});
                throw new IOException("read certificate from cert path error", e);
            }
        }
        trustStore = ProvContext.getStore(path, type, provider, pass);
        return trustStore;
    }

    public static KeyStore getStore(String path, String type, String provider, String pass) throws IOException {
        KeyStore ks = null;
        InputStream in = null;
        try {
            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            in = FileUtils.getResourceAsStream((String)path);
            char[] storePass = null;
            if (pass != null && !"".equals(pass)) {
                storePass = pass.toCharArray();
            }
            ks.load(in, storePass);
        }
        catch (FileNotFoundException fnfe) {
            logger.error("jsse.keystore_load_failed {} {} {}", new Object[]{type, path, fnfe.getMessage(), fnfe});
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            logger.error("jsse.keystore_load_failed {} {} {}", new Object[]{type, path, ex.getMessage(), ex});
            throw new IOException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    static {
        if (Security.getProvider("XDJA") == null) {
            XdjaSecurity.addFirstProvider((Provider)new XdjaProvider());
        }
        if (Security.getProvider("XDJAJSSE") == null) {
            Security.addProvider((Provider)new XdjaJsseProvider());
        }
        logger = LoggerFactory.getLogger((String)ProvContext.class.getName());
    }
}

