/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jprov.http.api;

import com.xdja.jce.base.provider.XdjaProvider;
import com.xdja.jce.base.provider.config.XdjaSecurity;
import com.xdja.jce.logger.Logger;
import com.xdja.jce.logger.LoggerFactory;
import com.xdja.jprov.context.ProvContext;
import com.xdja.jprov.context.ProvException;
import com.xdja.jprov.http.bean.ProvHttpClientConfig;
import com.xdja.jprov.http.bean.ProvHttpMethod;
import com.xdja.jprov.http.bean.ProvHttpRequest;
import com.xdja.jprov.http.bean.ProvHttpResponse;
import com.xdja.jprov.http.bean.ProvHttpsClientConfig;
import com.xdja.jprov.http.exception.ProvHttpErrorCode;
import com.xdja.jprov.http.exception.ProvHttpException;
import com.xdja.jsse.provider.XdjaJsseProvider;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public abstract class ProvBaseHttpClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ProvHttpClientConfig httpClientConfig;

    public ProvBaseHttpClient() {
    }

    public ProvBaseHttpClient(ProvHttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public ProvHttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public ProvHttpResponse connect(ProvHttpMethod httpMethod, ProvHttpRequest request) throws ProvHttpException {
        int statusCode;
        String uri = this.generateURL(request);
        HttpURLConnection connection = null;
        URL conUrl = null;
        try {
            conUrl = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.GENERATE_URL_ERROR);
        }
        try {
            connection = (HttpURLConnection)conUrl.openConnection();
        }
        catch (IOException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.OPENCONNECTION_ERROR);
        }
        Map<String, String> headers = request.getHeaders();
        if (headers != null && headers.size() != 0) {
            for (String key : headers.keySet()) {
                connection.setRequestProperty(key, headers.get(key));
                this.logger.info("http request set header {}={}", (Object)key, (Object)headers.get(key));
            }
        }
        if (this.httpClientConfig != null) {
            int readTimeout;
            int connectTimeout = this.httpClientConfig.getConnectTimeout();
            if (connectTimeout != 0) {
                connection.setConnectTimeout(connectTimeout);
                this.logger.info("http request set connect timeout {}", (Object)connectTimeout);
            }
            if ((readTimeout = this.httpClientConfig.getReadTimeout()) != 0) {
                connection.setReadTimeout(readTimeout);
                this.logger.info("http request set read timeout {}", (Object)readTimeout);
            }
            this.setSSLSocketFactory(connection);
            connection.setDoInput(this.httpClientConfig.isDoinput());
            connection.setDoOutput(this.httpClientConfig.isDooutput());
        }
        try {
            String method = httpMethod.getValue();
            this.logger.info("http request method is {}", (Object)method);
            connection.setRequestMethod(method);
            if (!connection.getDoOutput() && ProvHttpMethod.isDoOutput(method)) {
                connection.setDoOutput(true);
            }
        }
        catch (ProtocolException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.SET_REQUEST_METHOD_ERROR);
        }
        try {
            connection.connect();
        }
        catch (IOException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.CONNECTION_ERROR);
        }
        this.writeRequestBody(connection, request);
        ProvHttpResponse response = new ProvHttpResponse();
        response.setHeaders(connection.getHeaderFields());
        try {
            statusCode = connection.getResponseCode();
            response.setStatusCode(statusCode);
        }
        catch (IOException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.CONNECTION_GET_RESPONSE_STATUS_CODE_ERROR);
        }
        try {
            String responseMessage = connection.getResponseMessage();
            response.setStatusMessage(responseMessage);
        }
        catch (IOException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.CONNECTION_GET_RESPONSE_STATUS_CODE_ERROR);
        }
        this.readResponseBody(connection, statusCode, response);
        return response;
    }

    private String generateURL(ProvHttpRequest request) throws ProvHttpException {
        StringBuilder sb = new StringBuilder(request.getUrl());
        URL url = null;
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.URL_ERROR);
        }
        Map<String, String> params = request.getParams();
        if (params != null && params.size() != 0) {
            if (url.getQuery() == null) {
                sb.append("?");
            }
            for (String key : params.keySet()) {
                try {
                    String keyEncode = URLEncoder.encode(key, "UTF-8");
                    String valueEncode = URLEncoder.encode(params.get(key), "UTF-8");
                    sb.append(keyEncode).append("=").append(valueEncode).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    String errorMessage = "url encode exception key: " + key + " value: " + params.get(key);
                    throw new ProvHttpException(errorMessage, e, ProvHttpErrorCode.GENERATE_URL_ERROR);
                }
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        String uri = sb.toString();
        this.logger.info("http request url is {}", (Object)uri);
        return uri;
    }

    private void setSSLSocketFactory(HttpURLConnection connection) throws ProvHttpException {
        if (this.httpClientConfig instanceof ProvHttpsClientConfig) {
            ProvHttpsClientConfig httpsClientConfig = (ProvHttpsClientConfig)this.httpClientConfig;
            String sslProtocol = httpsClientConfig.getSslProtocol();
            if (httpsClientConfig.isSslEnabled() && sslProtocol != null) {
                this.logger.info("http request set ssl protocol {}", (Object)sslProtocol);
                try {
                    SSLSocketFactory socketFactory = null;
                    socketFactory = httpsClientConfig.getClientKeyStore() != null && httpsClientConfig.getTrustStore() != null ? ProvContext.getClientInstance(httpsClientConfig.getClientKeyStore(), httpsClientConfig.getClientKeyStorePassword().toCharArray(), httpsClientConfig.getTrustStore(), sslProtocol).getSocketFactory() : (httpsClientConfig.getTrustStore() != null ? ProvContext.getClientInstance(httpsClientConfig.getTrustStorePassword().toCharArray(), httpsClientConfig.getTrustStore(), sslProtocol).getSocketFactory() : ProvContext.getClientInstance(sslProtocol).getSocketFactory());
                    ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
                }
                catch (ProvException | IOException e) {
                    throw new ProvHttpException(e, ProvHttpErrorCode.GENERATE_SSL_SOCKET_FACTORY_ERROR);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeRequestBody(HttpURLConnection connection, ProvHttpRequest request) throws ProvHttpException {
        OutputStream outputStream;
        byte[] body = request.getBody();
        if (body == null) return;
        if (body.length <= 0) return;
        try {
            outputStream = connection.getOutputStream();
        }
        catch (IOException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.CONNECTION_GET_OUTPUT_STREAM_ERROR);
        }
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            dos.write(body);
            return;
        }
        catch (IOException e) {
            throw new ProvHttpException("write error", e, ProvHttpErrorCode.CONNECTION_WRITE_BODY_ERROR);
        }
        finally {
            try {
                dos.flush();
            }
            catch (IOException e) {
                throw new ProvHttpException("flush error", e, ProvHttpErrorCode.CONNECTION_WRITE_BODY_ERROR);
            }
            finally {
                try {
                    dos.close();
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new ProvHttpException("close error", e, ProvHttpErrorCode.CONNECTION_WRITE_BODY_ERROR);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readResponseBody(HttpURLConnection connection, int statusCode, ProvHttpResponse response) throws ProvHttpException {
        InputStream inputStream;
        int contentLength = connection.getContentLength();
        try {
            inputStream = 200 <= statusCode && statusCode <= 299 ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (IOException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.CONNECTION_GET_INPUT_STREAM_ERROR);
        }
        if (inputStream == null) {
            this.logger.error("connection content length is {}, but input stream is null", (Object)contentLength);
            return;
        }
        if (this.httpClientConfig.isResponseUseStream()) {
            response.setInputStream(inputStream);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        try {
            while ((length = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new ProvHttpException(e, ProvHttpErrorCode.CONNECTION_GET_RESPONSE_BODY_ERROR);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                throw new ProvHttpException("close bos error", e, ProvHttpErrorCode.CONNECTION_GET_RESPONSE_BODY_ERROR);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new ProvHttpException("close input stream error", e, ProvHttpErrorCode.CONNECTION_GET_RESPONSE_BODY_ERROR);
                }
            }
        }
        byte[] body = bos.toByteArray();
        response.setBody(body);
    }

    static {
        if (Security.getProvider("XDJA") == null) {
            XdjaSecurity.addFirstProvider((Provider)new XdjaProvider());
        }
        if (Security.getProvider("XDJAJSSE") == null) {
            Security.addProvider((Provider)new XdjaJsseProvider());
        }
    }
}

