/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jprov.https;

import com.xdja.jce.logger.Logger;
import com.xdja.jce.logger.LoggerFactory;
import com.xdja.jprov.context.ProvContext;
import com.xdja.jprov.context.ProvException;
import com.xdja.jprov.http.bean.ProvProtocol;
import com.xdja.jprov.https.GMHttpsException;
import com.xdja.jprov.https.GMHttpsMethod;
import com.xdja.jprov.https.GMHttpsRequest;
import com.xdja.jprov.https.GMHttpsResponse;
import com.xdja.jprov.https.GMHttpsUtils;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class GMHttpsClient {
    private SSLSocketFactory socketFactory;
    private static Logger logger = LoggerFactory.getLogger((String)GMHttpsClient.class.getName());

    public GMHttpsClient(String protocol) throws GMHttpsException {
        try {
            this.socketFactory = ProvContext.getClientInstance(protocol).getSocketFactory();
        }
        catch (ProvException e) {
            throw new GMHttpsException("get client instance exception", e);
        }
    }

    public GMHttpsClient(KeyStore keyStore, char[] password, KeyStore trustStore) throws GMHttpsException {
        try {
            this.socketFactory = ProvContext.getClientInstance(keyStore, password, trustStore, ProvProtocol.GMSSLv11.getValue()).getSocketFactory();
        }
        catch (ProvException e) {
            throw new GMHttpsException("get client instance exception", e);
        }
    }

    private HttpsURLConnection getHttpsURLConnection(String url, GMHttpsMethod method, byte[] body) throws GMHttpsException {
        HttpsURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)new URL(url).openConnection();
            connection.setRequestProperty("Content-type", "text/plain");
            connection.setSSLSocketFactory(this.socketFactory);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            if (GMHttpsMethod.GET.equals((Object)method)) {
                connection.connect();
            }
            if (GMHttpsMethod.POST.equals((Object)method)) {
                connection.setDoOutput(true);
                GMHttpsUtils.writeBytes(connection.getOutputStream(), body);
            }
        }
        catch (IOException e) {
            throw new GMHttpsException("get client instance exception", e);
        }
        return connection;
    }

    public GMHttpsResponse request(GMHttpsRequest request) throws GMHttpsException {
        logger.info(request.toString());
        try {
            HttpsURLConnection connection = this.getHttpsURLConnection(request.getUri(), request.getMethod(), request.getBody());
            byte[] response = null;
            if (connection.getResponseCode() == 200) {
                response = GMHttpsUtils.readBytes(connection.getInputStream());
            }
            connection.disconnect();
            return new GMHttpsResponse(connection.getResponseCode(), response);
        }
        catch (IOException e) {
            throw new GMHttpsException("GMHttpsClient request exception", e);
        }
    }

    public GMHttpsResponse get(String uri) throws GMHttpsException {
        return this.request(new GMHttpsRequest(null, uri, GMHttpsMethod.GET, null));
    }

    public GMHttpsResponse post(String uri, byte[] body) throws GMHttpsException {
        return this.request(new GMHttpsRequest(null, uri, GMHttpsMethod.POST, body));
    }

    public GMHttpsResponse post(String uri, String body) throws GMHttpsException {
        return this.request(new GMHttpsRequest(null, uri, GMHttpsMethod.POST, body.getBytes()));
    }

    public void asyncRequest(GMHttpsRequest request, Listener listener) throws GMHttpsException {
        HttpsURLConnection connection = this.getHttpsURLConnection(request.getUri(), request.getMethod(), request.getBody());
        new Thread(() -> {
            try {
                if (connection.getResponseCode() == 200) {
                    byte[] response = GMHttpsUtils.readBytes(connection.getInputStream());
                    listener.onResponse(new GMHttpsResponse(connection.getResponseCode(), response));
                } else {
                    listener.onResponseError("response code: " + connection.getResponseCode());
                }
            }
            catch (IOException e) {
                listener.onResponseError("read response error: " + e.toString());
            }
        }).start();
    }

    public void asyncGet(String url, Listener listener) throws GMHttpsException {
        this.asyncRequest(new GMHttpsRequest(null, url, GMHttpsMethod.GET, null), listener);
    }

    public void asyncPost(String url, String body, Listener listener) throws GMHttpsException {
        this.asyncRequest(new GMHttpsRequest(null, url, GMHttpsMethod.POST, body.getBytes()), listener);
    }

    public void asyncPost(String url, byte[] body, Listener listener) throws GMHttpsException {
        this.asyncRequest(new GMHttpsRequest(null, url, GMHttpsMethod.POST, body), listener);
    }

    public static interface Listener {
        public void onResponse(GMHttpsResponse var1);

        public void onResponseError(String var1);
    }
}

