/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.gmssl.tomcat.plugin;

import com.xdja.jce.base.util.KeyStoreUtils;
import com.xdja.jce.gmssl.tomcat.plugin.XDJAJSSEGMSSLContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.res.StringManager;

public class XDJAJSSEUtil
implements SSLUtil {
    private static final Log log = LogFactory.getLog(XDJAJSSEUtil.class);
    private static final StringManager sm = StringManager.getManager(XDJAJSSEUtil.class);
    private final SSLHostConfigCertificate certificate;
    private final SSLHostConfig sslHostConfig;

    public XDJAJSSEUtil(SSLHostConfigCertificate certificate) {
        this.certificate = certificate;
        this.sslHostConfig = certificate.getSSLHostConfig();
    }

    public SSLContext createSSLContext(List<String> negotiableProtocols) throws Exception {
        XDJAJSSEGMSSLContext sslContext = new XDJAJSSEGMSSLContext(this.sslHostConfig.getSslProtocol());
        sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
        return sslContext;
    }

    public KeyManager[] getKeyManagers() throws Exception {
        String password = this.sslHostConfig.getCertificateKeystorePassword();
        KeyStore ks = KeyStoreUtils.getKeystore((String)this.certificate.getCertificateKeystoreFile(), (String)this.certificate.getCertificateKeystoreType(), (String)this.certificate.getCertificateKeystoreProvider(), (String)password);
        KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "XDJAJSSE");
        keyMgrFact.init(ks, password.toCharArray());
        return keyMgrFact.getKeyManagers();
    }

    public TrustManager[] getTrustManagers() throws Exception {
        KeyStore ts = KeyStoreUtils.getTrustStore((String)this.sslHostConfig.getTruststoreFile(), (String)this.sslHostConfig.getTruststoreType(), (String)this.sslHostConfig.getTruststoreProvider(), (String)this.sslHostConfig.getTruststorePassword());
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "XDJAJSSE");
        trustMgrFact.init(ts);
        return trustMgrFact.getTrustManagers();
    }

    private KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream in = null;
        try {
            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            in = ConfigFileLoader.getInputStream((String)path);
            char[] storePass = null;
            if (pass != null && !"".equals(pass)) {
                storePass = pass.toCharArray();
            }
            ks.load(in, storePass);
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)sm.getString("jsse.keystore_load_failed", new Object[]{type, path, fnfe.getMessage()}), (Throwable)fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            String msg = sm.getString("jsse.keystore_load_failed", new Object[]{type, path, ex.getMessage()});
            log.error((Object)msg, (Throwable)ex);
            throw new IOException(msg);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    public void configureSessionContext(SSLSessionContext sslSessionContext) {
        sslSessionContext.setSessionCacheSize(this.sslHostConfig.getSessionCacheSize());
        sslSessionContext.setSessionTimeout(this.sslHostConfig.getSessionTimeout());
    }

    public String[] getEnabledProtocols() throws IllegalArgumentException {
        return new String[]{"GMSSLv1.1"};
    }

    public String[] getEnabledCiphers() throws IllegalArgumentException {
        return new String[]{"GMSSL_ECC_SM4_SM3", "GMSSL_RSA_SM4_SM3"};
    }
}

