/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jce.gmssl.tomcat.plugin;

import com.xdja.jce.base.provider.XdjaProvider;
import com.xdja.jce.logger.Logger;
import com.xdja.jce.logger.LoggerFactory;
import com.xdja.jsse.provider.XdjaJsseProvider;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class XDJAServletContextListener
implements ServletContextListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void contextInitialized(ServletContextEvent sce) {
        this.logger.info("XDJA GMSSL TOMCAT PLUGIN contextInitialized start!");
        this.printEnvProperties();
        this.logger.info("XDJA GMSSL TOMCAT PLUGIN contextInitialized done!");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.logger.info("XDJA GMSSL TOMCAT PLUGIN contextDestroyed done!");
    }

    public void printEnvProperties() {
        this.logger.info("ENV============================================");
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.logger.info(entry.getKey() + "=" + entry.getValue());
        }
        this.logger.info("Properties============================================");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            this.logger.info(entry.getKey() + "=" + entry.getValue());
        }
        this.logger.info("XDJA GMSSL TOMCAT PLUGIN contextInitialized done!");
    }

    static {
        if (Security.getProvider("XDJA") == null) {
            Security.addProvider((Provider)new XdjaProvider());
        }
        if (Security.getProvider("XDJAJSSE") == null) {
            Security.addProvider((Provider)new XdjaJsseProvider());
        }
    }
}

