/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTAutoComplete;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.util.AttributeSet;
import android.widget.ListAdapter;
import com.xdja.jwtcomponentslibrary.JWTAutoComplete.JWTAutoCompleteSearchAdapter;
import com.xdja.jwtcomponentslibrary.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JWTAutoComplete<T>
extends AppCompatAutoCompleteTextView {
    private Context mContext;
    private JWTAutoCompleteSearchAdapter<T> searchAdapter;
    private List<T> mData = new ArrayList<T>();
    private boolean showAllData = false;

    public JWTAutoComplete(Context context) {
        this(context, null);
    }

    public JWTAutoComplete(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public JWTAutoComplete(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.JWTAutoComplete);
        if (typedArray != null) {
            typedArray.recycle();
        }
        this.setSingleLine(true);
        Resources resources = this.mContext.getResources();
        int padding = resources.getDimensionPixelOffset(R.dimen.size9);
        this.setPadding(padding, padding, padding, padding);
        this.setMinHeight(resources.getDimensionPixelOffset(R.dimen.size1));
        this.setBackgroundResource(R.drawable.jwt_edittext_bg_selector);
    }

    public void initAdapter() {
        this.searchAdapter = new JWTAutoCompleteSearchAdapter<T>(this.getContext(), 17367043, this.mData, -1);
        this.setAdapter((ListAdapter)this.searchAdapter);
    }

    public void setData(T[] data) {
        this.mData = Arrays.asList(data);
        this.initAdapter();
    }

    public void setData(List<T> data) {
        this.mData = data;
        this.initAdapter();
    }

    public T getItem(int position) {
        return this.searchAdapter.getItem(position);
    }

    public int getPosition(T item) {
        return this.searchAdapter.getPosition(item);
    }

    public boolean isShowAllData() {
        return this.showAllData;
    }

    public void setShowAllData(boolean showAllData) {
        this.showAllData = showAllData;
    }

    public boolean enoughToFilter() {
        return this.showAllData || super.enoughToFilter();
    }
}

