/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.View;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextCallBack;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextInputSoft;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.KeyboardUtils;

public class JWTEditText
extends AppCompatEditText
implements View.OnClickListener,
JWTEditTextCallBack {
    private Context mContext;
    private int mInputType;
    private int mThreshold;

    public JWTEditText(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public JWTEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
        this.initParams(attrs);
    }

    public JWTEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
        this.initParams(attrs);
    }

    private void initParams(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.JWTEditText);
        if (typedArray != null) {
            this.mInputType = typedArray.getInt(R.styleable.JWTEditText_inputType, 0);
            this.mThreshold = typedArray.getInt(R.styleable.JWTEditText_threshold, 2);
            typedArray.recycle();
        }
    }

    private void init() {
        this.setFocusable(false);
        Resources resources = this.mContext.getResources();
        int padding = resources.getDimensionPixelOffset(R.dimen.size9);
        this.setPadding(padding, padding, padding, padding);
        this.setMinHeight(resources.getDimensionPixelOffset(R.dimen.size1));
        this.setBackgroundResource(R.drawable.jwt_edittext_bg_selector);
        this.setOnClickListener(this);
    }

    public void onClick(View view) {
        KeyboardUtils.hideSoftInput(this.mContext, (View)this);
        JWTEditTextInputSoft soft = new JWTEditTextInputSoft(this.mContext);
        String textStr = "";
        if (this.getText() != null) {
            textStr = this.getText().toString();
        }
        String hintStr = "";
        if (this.getHint() != null) {
            hintStr = this.getHint().toString();
        }
        soft.setCallBack(this);
        soft.setThreshold(this.mThreshold);
        soft.showInputSoft(this.mInputType, textStr, hintStr);
    }

    @Override
    public void onConfirm(String str) {
        this.setText(str);
    }
}

