/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextDBHelper;
import java.util.ArrayList;
import java.util.List;

public class JWTEditTextDBUtils {
    private Context mContext;
    private JWTEditTextDBHelper dbHelper;
    private SQLiteDatabase sqLiteDatabase;
    private static final Object object = new Object();

    public JWTEditTextDBUtils(Context context) {
        this.mContext = context;
        this.dbHelper = new JWTEditTextDBHelper(context);
        this.openDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDatabase() {
        Object object = JWTEditTextDBUtils.object;
        synchronized (object) {
            if (this.sqLiteDatabase == null || !this.sqLiteDatabase.isOpen()) {
                this.sqLiteDatabase = this.dbHelper.getWritableDatabase();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeDatabase() {
        Object object = JWTEditTextDBUtils.object;
        synchronized (object) {
            if (this.sqLiteDatabase != null) {
                this.sqLiteDatabase.close();
                this.sqLiteDatabase = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int insert(String content) {
        int result = 0;
        Object object = JWTEditTextDBUtils.object;
        synchronized (object) {
            try {
                String sql = "insert into t_history(c_content, c_time) values(?, ?)";
                this.sqLiteDatabase.execSQL(sql, new Object[]{content, System.currentTimeMillis()});
            }
            catch (Exception e) {
                e.printStackTrace();
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int update(String content) {
        int result = 0;
        Object object = JWTEditTextDBUtils.object;
        synchronized (object) {
            try {
                String sql = "update t_history set c_time = ? where c_content = ?";
                this.sqLiteDatabase.execSQL(sql, new Object[]{System.currentTimeMillis(), content});
            }
            catch (Exception e) {
                e.printStackTrace();
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<String> query(String keyword) {
        ArrayList<String> result = new ArrayList<String>();
        try (Cursor cursor = null;){
            String sql = "select c_content from t_history where c_content like ? order by c_time desc limit 0,2";
            cursor = this.sqLiteDatabase.rawQuery(sql, new String[]{"%" + keyword + "%"});
            while (cursor != null && cursor.moveToNext()) {
                result.add(cursor.getString(cursor.getColumnIndex("c_content")));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int saveHistory(String content) {
        int result;
        try (Cursor cursor = null;){
            String querySql = "select 1 from t_history where c_content = ?";
            cursor = this.sqLiteDatabase.rawQuery(querySql, new String[]{"%" + content + "%"});
            result = cursor != null && cursor.moveToNext() ? this.update(content) : this.insert(content);
        }
        return result;
    }
}

