/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextCallBack;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextDBUtils;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextDataAdapter;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.ToastUtils;
import com.xdja.jwtcomponentslibrary.utils.VibrationUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JWTEditTextInputSoft
implements View.OnClickListener,
View.OnLongClickListener,
AdapterView.OnItemClickListener,
TextWatcher,
View.OnTouchListener,
ViewPager.OnPageChangeListener {
    private Context mContext;
    private JWTEditTextCallBack mJWTEditTextCallBack;
    private int mThreshold;
    private String mDefaultText;
    private final List<String> tsclData = new ArrayList<String>();
    private final List<String> sfData = new ArrayList<String>();
    private final List<String> zmData = new ArrayList<String>();
    private final List<String> zm_yData = new ArrayList<String>();
    private final List<String> zm_xData = new ArrayList<String>();
    private final List<String> sfzData = new ArrayList<String>();
    private PopupWindow popupWindow;
    private View popupView;
    private TextView tsclTv;
    private TextView sfTv;
    private TextView zmTv;
    private TextView szTv;
    private Button copyBtn;
    private Button delBtn;
    private Button confirmBtn;
    private ImageView closeBtn;
    private ListView listView;
    private EditText clearEdit;
    private ViewPager viewPager;
    private List<View> views = new ArrayList<View>();
    private GridView tsclView;
    private GridView sfGridView;
    private GridView zmGridView;
    private GridView sfzGridView;
    private JWTEditTextDataAdapter tsclAdapter;
    private JWTEditTextDataAdapter sfAdapter;
    private JWTEditTextDataAdapter zmAdapter;
    private JWTEditTextDataAdapter sfzAdapter;
    private PagerAdapter pagerAdapter;
    private JWTEditTextDBUtils dbUtils;
    private List<String> queryData;

    public JWTEditTextInputSoft(Context context) {
        this.mContext = context;
        this.initData();
        this.initPopupView();
        this.initPopupWindow();
        this.initGridViews();
        this.initPagerAdapter();
    }

    private void initPagerAdapter() {
        this.pagerAdapter = new PagerAdapter(){

            public boolean isViewFromObject(View arg0, Object arg1) {
                return arg0 == arg1;
            }

            public int getCount() {
                return JWTEditTextInputSoft.this.views == null ? 0 : JWTEditTextInputSoft.this.views.size();
            }

            public void destroyItem(ViewGroup container, int position, Object view) {
                container.removeView((View)view);
            }

            public Object instantiateItem(ViewGroup collection, int position) {
                View view = (View)JWTEditTextInputSoft.this.views.get(position);
                collection.addView(view, 0);
                return view;
            }
        };
        this.viewPager.setOffscreenPageLimit(1);
        this.viewPager.setAdapter(this.pagerAdapter);
    }

    private void initGridViews() {
        for (int i = 0; i < 4; ++i) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_edittext_gridview, null);
            GridView gridView = (GridView)view.findViewById(R.id.soft_grid_view);
            gridView.setHorizontalSpacing(12);
            gridView.setVerticalSpacing(12);
            this.initGridView(gridView, i);
            this.views.add(view);
        }
    }

    private void initGridView(GridView gridView, int type) {
        switch (type) {
            case 0: {
                this.tsclView = gridView;
                this.tsclView.setNumColumns(3);
                this.tsclAdapter = new JWTEditTextDataAdapter(this.mContext, this.tsclData);
                this.tsclView.setAdapter((ListAdapter)this.tsclAdapter);
                break;
            }
            case 1: {
                this.sfGridView = gridView;
                this.sfGridView.setNumColumns(7);
                this.sfAdapter = new JWTEditTextDataAdapter(this.mContext, this.sfData);
                this.sfGridView.setAdapter((ListAdapter)this.sfAdapter);
                break;
            }
            case 2: {
                this.zmGridView = gridView;
                this.zmGridView.setNumColumns(6);
                this.zmData.addAll(this.zm_yData);
                this.zmAdapter = new JWTEditTextDataAdapter(this.mContext, this.zmData);
                this.zmGridView.setAdapter((ListAdapter)this.zmAdapter);
                break;
            }
            case 3: {
                this.sfzGridView = gridView;
                this.sfzGridView.setNumColumns(3);
                this.sfzAdapter = new JWTEditTextDataAdapter(this.mContext, this.sfzData);
                this.sfzGridView.setAdapter((ListAdapter)this.sfzAdapter);
            }
        }
        if (this.tsclView != null) {
            this.tsclView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.tsclData.get(position));
                }
            });
        }
        if (this.sfGridView != null) {
            this.sfGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.sfData.get(position));
                }
            });
        }
        if (this.zmGridView != null) {
            this.zmGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    if ("\u5927\u5199".equals(JWTEditTextInputSoft.this.zmData.get(position))) {
                        JWTEditTextInputSoft.this.zmData.clear();
                        JWTEditTextInputSoft.this.zmData.addAll(JWTEditTextInputSoft.this.zm_yData);
                        JWTEditTextInputSoft.this.zmAdapter.notifyDataSetChanged();
                    } else if ("\u5c0f\u5199".equals(JWTEditTextInputSoft.this.zmData.get(position))) {
                        JWTEditTextInputSoft.this.zmData.clear();
                        JWTEditTextInputSoft.this.zmData.addAll(JWTEditTextInputSoft.this.zm_xData);
                        JWTEditTextInputSoft.this.zmAdapter.notifyDataSetChanged();
                    } else {
                        JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.zmData.get(position));
                    }
                }
            });
        }
        if (this.sfzGridView != null) {
            this.sfzGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.sfzData.get(position));
                }
            });
        }
    }

    private void initPopupView() {
        if (this.popupView == null) {
            this.popupView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_edittext_inputsoft, null);
            this.tsclTv = (TextView)this.popupView.findViewById(R.id.tscl_btn);
            this.sfTv = (TextView)this.popupView.findViewById(R.id.sf_btn);
            this.zmTv = (TextView)this.popupView.findViewById(R.id.zm_btn);
            this.szTv = (TextView)this.popupView.findViewById(R.id.sz_btn);
            this.copyBtn = (Button)this.popupView.findViewById(R.id.copy_btn);
            this.delBtn = (Button)this.popupView.findViewById(R.id.del_btn);
            this.confirmBtn = (Button)this.popupView.findViewById(R.id.confirm_btn);
            this.closeBtn = (ImageView)this.popupView.findViewById(R.id.close_btn);
            this.listView = (ListView)this.popupView.findViewById(R.id.history_lsit);
            this.clearEdit = (EditText)this.popupView.findViewById(R.id.result_edit);
            this.viewPager = (ViewPager)this.popupView.findViewById(R.id.edit_viewpager);
            this.tsclTv.setOnClickListener((View.OnClickListener)this);
            this.sfTv.setOnClickListener((View.OnClickListener)this);
            this.zmTv.setOnClickListener((View.OnClickListener)this);
            this.szTv.setOnClickListener((View.OnClickListener)this);
            this.copyBtn.setOnClickListener((View.OnClickListener)this);
            this.delBtn.setOnClickListener((View.OnClickListener)this);
            this.delBtn.setOnLongClickListener((View.OnLongClickListener)this);
            this.confirmBtn.setOnClickListener((View.OnClickListener)this);
            this.closeBtn.setOnClickListener((View.OnClickListener)this);
            this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
            this.clearEdit.setOnTouchListener((View.OnTouchListener)this);
            this.clearEdit.addTextChangedListener((TextWatcher)this);
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.clearEdit.setShowSoftInputOnFocus(false);
        }
    }

    private void initPopupWindow() {
        if (this.popupWindow == null) {
            this.popupWindow = new PopupWindow(this.popupView, -1, -2);
            this.popupWindow.setFocusable(true);
            this.popupWindow.setOutsideTouchable(true);
            this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1090519040));
            this.popupWindow.setSoftInputMode(16);
        }
    }

    private void initData() {
        String[] tscl_data_array = this.mContext.getResources().getStringArray(R.array.tscl);
        this.tsclData.clear();
        this.tsclData.addAll(Arrays.asList(tscl_data_array));
        String[] sf_data_array = this.mContext.getResources().getStringArray(R.array.sf);
        this.sfData.clear();
        this.sfData.addAll(Arrays.asList(sf_data_array));
        String[] zm_data_array = this.mContext.getResources().getStringArray(R.array.zm_y);
        this.zm_yData.clear();
        this.zm_yData.addAll(Arrays.asList(zm_data_array));
        String[] zmx_data_array = this.mContext.getResources().getStringArray(R.array.zm_x);
        this.zm_xData.clear();
        this.zm_xData.addAll(Arrays.asList(zmx_data_array));
        String[] sfz_data_array = this.mContext.getResources().getStringArray(R.array.sfz);
        this.sfzData.clear();
        this.sfzData.addAll(Arrays.asList(sfz_data_array));
    }

    public void setCallBack(JWTEditTextCallBack JWTEditTextCallBack2) {
        this.mJWTEditTextCallBack = JWTEditTextCallBack2;
    }

    public void setThreshold(int threshold) {
        this.mThreshold = threshold;
    }

    public void showInputSoft(int inputType, String defaultText, String hint) {
        this.mDefaultText = defaultText;
        this.clearEdit.setText((CharSequence)defaultText);
        this.clearEdit.setSelection(defaultText.length());
        this.clearEdit.setHint((CharSequence)hint);
        this.viewPager.setCurrentItem(inputType);
        if (this.popupWindow != null && this.popupView != null) {
            this.popupWindow.showAtLocation(this.popupView.getRootView(), 80, 0, 0);
        }
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.copy_btn) {
            this.vibrate();
            this.copyAction();
        } else if (i == R.id.del_btn) {
            this.vibrate();
            this.delAction();
        } else if (i == R.id.confirm_btn) {
            this.vibrate();
            this.confirmAction(this.clearEdit.getText().toString());
        } else if (i == R.id.close_btn) {
            this.vibrate();
            this.dismiss();
        } else if (i == R.id.tscl_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(0);
        } else if (i == R.id.sf_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(1);
        } else if (i == R.id.zm_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(2);
        } else if (i == R.id.sz_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(3);
        }
    }

    private void dismiss() {
        if (this.dbUtils != null) {
            this.dbUtils.closeDatabase();
            this.dbUtils = null;
        }
        this.popupWindow.dismiss();
    }

    private void confirmAction(String content) {
        if (this.dbUtils == null) {
            this.dbUtils = new JWTEditTextDBUtils(this.mContext);
        }
        this.dbUtils.saveHistory(content);
        if (this.mJWTEditTextCallBack != null) {
            this.mJWTEditTextCallBack.onConfirm(content);
        }
        this.dismiss();
    }

    private void delAction() {
        String text = this.clearEdit.getText().toString();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        int selection = this.clearEdit.getSelectionStart();
        if (selection <= 0) {
            return;
        }
        this.clearEdit.setText((CharSequence)String.format("%s%s", text.substring(0, selection - 1), text.substring(selection)));
        this.clearEdit.setSelection(selection - 1);
    }

    private void copyAction() {
        ClipboardManager cmb = (ClipboardManager)this.mContext.getSystemService("clipboard");
        cmb.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)this.clearEdit.getText().toString()));
        this.showToast("\u5df2\u7ecf\u590d\u5236\u5230\u7c98\u8d34\u677f\uff01");
    }

    public boolean onLongClick(View view) {
        this.clearEdit.setText((CharSequence)"");
        return true;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        if (this.queryData != null && this.queryData.size() > position) {
            this.confirmAction(this.queryData.get(position));
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
        if (TextUtils.isEmpty((CharSequence)editable.toString())) {
            this.listView.setVisibility(8);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDefaultText)) {
            this.listView.setVisibility(8);
            this.mDefaultText = "";
            return;
        }
        if (editable.length() > this.mThreshold) {
            List<String> result;
            if (this.dbUtils == null) {
                this.dbUtils = new JWTEditTextDBUtils(this.mContext);
            }
            if ((result = this.dbUtils.query(editable.toString())) == null || result.size() == 0) {
                this.listView.setVisibility(8);
            } else {
                this.queryData = result;
                this.listView.setVisibility(0);
                this.listView.setAdapter((ListAdapter)new ArrayAdapter(this.mContext, 17367043, result));
            }
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        EditText et = (EditText)view;
        Class<EditText> cls = EditText.class;
        try {
            Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
            setShowSoftInputOnFocus.setAccessible(false);
            setShowSoftInputOnFocus.invoke((Object)et, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        et.onTouchEvent(motionEvent);
        return true;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (position == 0) {
            this.tsclTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.zmTv.setBackground(null);
            this.szTv.setBackground(null);
            this.sfTv.setBackground(null);
            this.tsclTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor7));
            this.sfTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.zmTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.szTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
        } else if (position == 1) {
            this.sfTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.zmTv.setBackground(null);
            this.szTv.setBackground(null);
            this.tsclTv.setBackground(null);
            this.sfTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor7));
            this.zmTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.szTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.tsclTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
        } else if (position == 2) {
            this.zmTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.sfTv.setBackground(null);
            this.szTv.setBackground(null);
            this.tsclTv.setBackground(null);
            this.zmTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor7));
            this.sfTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.szTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.tsclTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
        } else if (position == 3) {
            this.szTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor7));
            this.sfTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.zmTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.tsclTv.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.cor3));
            this.szTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.sfTv.setBackground(null);
            this.zmTv.setBackground(null);
            this.tsclTv.setBackground(null);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void showToast(String message) {
        ToastUtils.showShortToast(this.mContext, message);
    }

    private void vibrate() {
        this.vibrate(20L);
    }

    private void vibrate(long milliseconds) {
        VibrationUtils.vibrate(this.mContext, milliseconds);
    }

    private void setResult(String input) {
        int selection = this.clearEdit.getSelectionStart();
        String text = this.clearEdit.getText().toString();
        this.clearEdit.setText((CharSequence)(text.substring(0, selection) + input + text.substring(selection)));
        this.clearEdit.setSelection(selection + input.length());
    }
}

