/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTSpinner;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import com.xdja.jwtcomponentslibrary.JWTAutoComplete.JWTAutoComplete;
import com.xdja.jwtcomponentslibrary.JWTSpinner.JWTSpinnerCallBack;
import com.xdja.jwtcomponentslibrary.JWTSpinner.JWTSpinnerDataItemBean;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.KeyboardUtils;
import java.util.ArrayList;
import java.util.List;

public class JWTSpinner
extends FrameLayout
implements AdapterView.OnItemSelectedListener,
View.OnClickListener {
    private Context mContext;
    private JWTAutoComplete<String> autoComplete;
    private ImageButton imageButton;
    private List<JWTSpinnerDataItemBean> mDataItemBeen = new ArrayList<JWTSpinnerDataItemBean>();
    private List<String> mTexts = new ArrayList<String>();
    private List<String> mValues = new ArrayList<String>();
    private JWTSpinnerCallBack mCallBack;
    private String selectedText;
    private String selectedValue;

    public JWTSpinner(Context context) {
        this(context, null);
    }

    public JWTSpinner(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public JWTSpinner(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_spinner, (ViewGroup)this);
        TypedArray ta = this.mContext.obtainStyledAttributes(attrs, R.styleable.JWTSpinner);
        if (ta != null) {
            this.autoComplete = (JWTAutoComplete)this.findViewById(R.id.jwt_spinner_autocomplete);
            this.imageButton = (ImageButton)this.findViewById(R.id.jwt_spinner_imgbtn);
            ta.recycle();
        }
        this.autoComplete.setThreshold(1);
        this.autoComplete.setOnItemSelectedListener(this);
        this.imageButton.setOnClickListener((View.OnClickListener)this);
    }

    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen) {
        this.setData(dataItemBeen, "");
    }

    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen, String defaultTextOrValue) {
        if (dataItemBeen == null || dataItemBeen.size() == 0) {
            return;
        }
        this.mDataItemBeen = dataItemBeen;
        for (int i = 0; i < this.mDataItemBeen.size(); ++i) {
            this.mTexts.add(i, this.mDataItemBeen.get(i).getText());
            this.mValues.add(i, this.mDataItemBeen.get(i).getValue());
        }
        this.autoComplete.setData(this.mTexts);
        this.setDefaultValue(defaultTextOrValue);
    }

    public void setDefaultValue(@NonNull String defaultTextOrValue) {
        int index = this.mTexts.indexOf(defaultTextOrValue);
        String defaultText = index == -1 ? ((index = this.mValues.indexOf(defaultTextOrValue)) == -1 ? "" : this.mTexts.get(index)) : defaultTextOrValue;
        this.autoComplete.setText(defaultText);
        this.autoComplete.setSelection(defaultText.length());
    }

    public void setCallBack(JWTSpinnerCallBack callBack) {
        this.mCallBack = callBack;
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    private void setSelectedText(String selectedText) {
        this.selectedText = selectedText;
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    private void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public boolean isInputValid() {
        return this.getSelectedPosition() != -1;
    }

    public int getSelectedPosition() {
        return this.mTexts.indexOf(this.autoComplete.getText().toString());
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mDataItemBeen == null || this.mDataItemBeen.size() <= position) {
            return;
        }
        this.setSelectedText(this.mDataItemBeen.get(position).getText());
        this.setSelectedValue(this.mDataItemBeen.get(position).getValue());
        if (this.mCallBack != null) {
            this.mCallBack.onItemSelected(this.getSelectedText(), this.getSelectedValue());
        }
    }

    public void onNothingSelected(AdapterView<?> parent) {
        this.setSelectedText("");
        this.setSelectedValue("");
        if (this.mCallBack != null) {
            this.mCallBack.onNothingSelected();
        }
    }

    public void onClick(View v) {
        if (!this.autoComplete.hasFocus()) {
            this.autoComplete.requestFocus();
        }
        this.autoComplete.setShowAllData(true);
        this.autoComplete.setText("");
        KeyboardUtils.hideSoftInput(this.mContext, (View)this);
    }

    public JWTAutoComplete<String> getAutoComplete() {
        return this.autoComplete;
    }

    public ImageButton getImageButton() {
        return this.imageButton;
    }
}

