package com.xdja.jwtcomponentslibrary.JWTAutoComplete;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author wanjing
 * @date
 *
 * @param <T>
 */
public class JWTAutoCompleteSearchAdapter<T> extends BaseAdapter implements Filterable {

    private List<T> mObjects;
    private final Object mLock = new Object();
    private int mResource;
    private int mFieldId = 0;
    private ArrayList<T> mOriginalValues;
    private ArrayFilter mFilter;
    private LayoutInflater mInflater;
    /**全部*/
    public static final int ALL = -1;
    /**最多显示多少个可能选项*/
    private int maxMatch = 10;

    public JWTAutoCompleteSearchAdapter(Context context, int textViewResourceId, T[] objects, int maxMatch) {
        init(context, textViewResourceId, 0, Arrays.asList(objects));
        this.maxMatch = maxMatch;
    }

    public JWTAutoCompleteSearchAdapter(Context context, int textViewResourceId, List<T> objects, int maxMatch) {
        init(context, textViewResourceId, 0, objects);
        this.maxMatch = maxMatch;
    }

    private void init(Context context, int resource, int textViewResourceId, List<T> objects) {
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        mResource = resource;
        mObjects = objects;
        mFieldId = textViewResourceId;
    }

    @Override
    public int getCount() {
        return mObjects == null ? 0 : mObjects.size();
    }

    @Override
    public T getItem(int position) {
        return mObjects == null ? null : mObjects.get(position);
    }

    public int getPosition(T item) {
        return mObjects == null ? -1 : mObjects.indexOf(item);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        return createViewFromResource(position, convertView, parent, mResource);
    }

    private View createViewFromResource(int position, View convertView, ViewGroup parent, int resource) {
        View view;
        TextView text;
        if (convertView == null) {
            view = mInflater.inflate(resource, parent, false);
        } else {
            view = convertView;
        }
        try {
            if (mFieldId == 0) {
                text = (TextView) view;
            } else {
                text = (TextView) view.findViewById(mFieldId);
            }
        } catch (ClassCastException e) {
            Log.e("ArrayAdapter", "You must supply a resource ID for a TextView");
            throw new IllegalStateException("ArrayAdapter requires the resource ID to be a TextView", e);
        }
        text.setText(getItem(position).toString());
        return view;
    }

    @Override
    public Filter getFilter() {
        if (mFilter == null) {
            mFilter = new ArrayFilter();
        }
        return mFilter;
    }

    private class ArrayFilter extends Filter {
        @Override
        protected FilterResults performFiltering(CharSequence prefix) {
            FilterResults results = new FilterResults();
            if (mOriginalValues == null) {
                synchronized (mLock) {
                    mOriginalValues = new ArrayList<T>(mObjects);
                }
            }

            if (prefix == null || prefix.length() == 0) {
                synchronized (mLock) {
                    ArrayList<T> list = new ArrayList<T>(mOriginalValues);
                    results.values = list;
                    results.count = list.size();
                }
            } else {
                String prefixString = prefix.toString().toLowerCase();

                // 汉字String
                final ArrayList<T> hanzi = mOriginalValues;
                final int count = hanzi.size();

                // 支持多音字,不重复
                final Set<T> newValues = new HashSet<T>(count);

                for (int i = 0; i < count; i++) {
                    // 汉字String
                    final T value = hanzi.get(i);
                    final String valueText = value.toString().toLowerCase();
                    // 如果是汉字则直接添加
                    if (valueText.contains(prefixString)) {
                        newValues.add(value);
                    }
                    // 有数量限制
                    if (maxMatch > 0) {
                        // 不要太多
                        if (newValues.size() > maxMatch - 1) {
                            break;
                        }
                    }

                }
                // 转成List
                List<T> list = Set2List(newValues);
                results.values = list;
                results.count = list.size();
            }
            return results;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected void publishResults(CharSequence constraint, FilterResults results) {
            mObjects = (List<T>) results.values;
            if (results.count > 0) {
                notifyDataSetChanged();
            } else {
                notifyDataSetInvalidated();
            }
        }
    }

    public void notifyAll(T[] objects) {
        notifyAll(Arrays.asList(objects));
    }

    public void notifyAll(List<T> objects) {
        mObjects = objects;
        mOriginalValues = null;
        notifyDataSetChanged();
    }

    /**
     * List Set 相互转换
     */
    @SuppressWarnings("hiding")
    public <T extends Object> Set<T> List2Set(List<T> tList) {
        Set<T> tSet = new HashSet<T>(tList);
        // 具体实现看需求转换成不同的Set的子类。
        return tSet;
    }

    @SuppressWarnings("hiding")
    public <T extends Object> List<T> Set2List(Set<T> oSet) {
        List<T> tList = new ArrayList<T>(oSet);
        // 需要在用到的时候另外写构造，根据需要生成List的对应子类。
        return tList;
    }
}
