package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.RelativeLayout;

import com.xdja.jwtcomponentslibrary.R;

import java.util.List;

/**
 * Created by wanjing on 2017/8/29.
 *
 * desc: 警务通输入法按键。
 */

public class JWTEditTextDataAdapter extends BaseAdapter {

    private Context mContext;
    private List<String> mData;

    private int height;

    public JWTEditTextDataAdapter(Context context, List<String> data, int numColumns) {
        this.mContext = context;
        this.mData = data;

        this.height = calculateHeight(context, numColumns);
    }

    @Override
    public int getCount() {
        return mData == null ? 0 : mData.size();
    }

    @Override
    public String getItem(int position) {
        return mData == null ? null : mData.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View view, ViewGroup viewGroup) {
        Button button = new Button(mContext);
        button.setBackgroundResource(R.drawable.jwt_btn_bg_keys);
        button.setTextColor(ContextCompat.getColor(mContext, R.color.jwt_input_soft_keys_text_color));
        button.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);
        button.setAllCaps(false);
        button.setFocusable(false);
        button.setClickable(false);
        button.setText(getItem(position));
        AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
        button.setLayoutParams(layoutParams);
        return button;
    }

    private int calculateHeight(Context context, int numColumns) {
        float scale = context.getResources().getDisplayMetrics().density;
        float parentHeight = 240 * scale + 0.5f;
        float padding = 4 * scale + 0.5f;
        int numRows = getCount() / numColumns + (getCount() % numColumns == 0 ? 0 : 1);
        return (int) (parentHeight / numRows - padding);
    }
}
