package com.xdja.jwtcomponentslibrary.JWTSpinner;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatSpinner;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.jwtcomponentslibrary.R;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wanjing
 * @date 2018/2/27
 *
 * 警务通spinner组件, 支持搜索。
 */

public class JWTSpinnerV1 extends AppCompatSpinner implements AdapterView.OnItemSelectedListener {

    private Context mContext;

    private List<JWTSpinnerDataItemBean> mDataItemBeen = new ArrayList<>();
    private String[] mDatas;

    private JWTSpinnerCallBack mCallBack;

    private String defaultTextOrValue;
    private int threshold;
    private @DrawableRes int bgResId;
    private @ColorInt int textColor;
    private float textSize;
    private int textAlignment;
    private int paddingLeft;
    private int paddingRight;

    private JWTSpinnerV1DialogView alertDialog;

    public JWTSpinnerV1(Context context) {
        this(context, null);
    }

    public JWTSpinnerV1(Context context, AttributeSet attrs) {
        super(context, attrs);

        init(context, attrs);
    }

    public JWTSpinnerV1(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;

        TypedArray ta = mContext.obtainStyledAttributes(attrs, R.styleable.JWTSpinnerV1);
        if (ta != null) {
            defaultTextOrValue = ta.getString(R.styleable.JWTSpinnerV1_default_text_value);
            threshold = ta.getInteger(R.styleable.JWTSpinnerV1_search_threshold, 5);
            bgResId = ta.getResourceId(R.styleable.JWTSpinnerV1_background, R.drawable.jwt_sp_btn_selector);
            textColor = ta.getColor(R.styleable.JWTSpinnerV1_spinner_textColor,
                    ContextCompat.getColor(context, R.color.spinnerV1_default_text_color));
            textSize = ta.getDimensionPixelSize(R.styleable.JWTSpinnerV1_spinner_textSize,
                    getResources().getDimensionPixelSize(R.dimen.spinnerV1_default_text_size));
            textAlignment = ta.getInteger(R.styleable.JWTSpinnerV1_spinner_textAlignment,
                    View.TEXT_ALIGNMENT_VIEW_START);
            paddingLeft = ta.getDimensionPixelSize(R.styleable.JWTSpinnerV1_spinner_paddingLeft, 0);
            paddingRight = ta.getDimensionPixelSize(R.styleable.JWTSpinnerV1_spinner_paddingRight, 0);

            ta.recycle();
        }

        setBackgroundResource(bgResId);
        setOnItemSelectedListener(this);
    }

    /**
     * 设置数据
     *
     * @param dataItemBeen 数据
     */
    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen) {
        setData(dataItemBeen, defaultTextOrValue);
    }

    /**
     * 设置数据和默认文本
     *
     * @param dataItemBeen 数据
     * @param defaultTextOrValue 默认文本/默认值
     */
    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen, String defaultTextOrValue) {
        if (dataItemBeen == null || dataItemBeen.size() == 0) {
            return;
        }
        this.mDataItemBeen = dataItemBeen;

        mDatas = new String[dataItemBeen.size()];
        for (int i = 0; i < mDataItemBeen.size(); i++) {
            mDatas[i] = dataItemBeen.get(i).getText();
        }
        ArrayAdapter arrayAdapter = new ArrayAdapter<String>(mContext, R.layout.jwt_spinner_v1_simple_list_item_1, mDatas){
            @NonNull
            @Override
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView textView = (TextView) view;
                textView.setTextColor(textColor);
                textView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
                textView.setTextAlignment(textAlignment);
                textView.setPadding(paddingLeft, 0, paddingRight, 0);
                return view;
            }
        };
        arrayAdapter.setDropDownViewResource(android.R.layout.simple_list_item_1);
        setAdapter(arrayAdapter);

        setDefaultValue(defaultTextOrValue);
    }

    /**
     * 设置默认文本
     *
     * @param defaultTextOrValue 默认文本/默认值
     */
    public void setDefaultValue(@NonNull String defaultTextOrValue) {
        int selectedPosition = -1;
        if (!TextUtils.isEmpty(defaultTextOrValue)) {
            for (JWTSpinnerDataItemBean dataItemBean : mDataItemBeen) {
                if (defaultTextOrValue.equals(dataItemBean.getText())
                        || defaultTextOrValue.equals(dataItemBean.getValue())) {
                    selectedPosition = mDataItemBeen.indexOf(dataItemBean);
                    break;
                }
            }
        }
        setSelection(selectedPosition, true);
    }

    public void setCallBack(JWTSpinnerCallBack callBack) {
        this.mCallBack = callBack;
    }

    public String getSelectedText() {
        return mDataItemBeen.get(getSelectedItemPosition()).getText();
    }

    public String getSelectedValue() {
        return mDataItemBeen.get(getSelectedItemPosition()).getValue();
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        if (mDataItemBeen == null || mDataItemBeen.size() <= position) {
            return;
        }
        if (mCallBack != null) {
            mCallBack.onItemSelected(getSelectedText(), getSelectedValue());
        }
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
        if (mCallBack != null) {
            mCallBack.onNothingSelected();
        }
    }

    @Override
    public boolean performClick() {
        if (mDataItemBeen != null && mDataItemBeen.size() > threshold) {
            // 数据过多，弹出dialog进行搜索
            showDialogView();
            return true;
        }

        // Else let the AppCompatSpinner handle the click
        return super.performClick();
    }

    /**
     * 展示搜索DialogView.
     */
    private void showDialogView() {
        if (alertDialog == null) {
            alertDialog = new JWTSpinnerV1DialogView(mContext, mDatas);
            alertDialog.setSearchItemClickCallBack(new JWTSpinnerV1DialogView.SearchItemClickCallBack<String>() {
                @Override
                public void onSearchItemClick(String item) {
                    for (int i = 0; i < mDatas.length; i++) {
                        if (item.equals(mDatas[i])) {
                            setSelection(i, true);
                            break;
                        }
                    }
                }
            });
        }
        alertDialog.notifyAll(mDatas);
        alertDialog.show();

        Window window = alertDialog.getWindow();
        if (window != null) {
            int width = (int) (mContext.getResources().getDisplayMetrics().density * 300 + 0.5f);
            int height = (int) (mContext.getResources().getDisplayMetrics().density * 224 + 0.5f);
            window.setLayout(width, height);
        }
    }
}
