/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.Button;
import com.xdja.jwtcomponentslibrary.R;
import java.util.List;

public class JWTEditTextDataAdapter
extends BaseAdapter {
    private Context mContext;
    private List<String> mData;
    private int height;

    public JWTEditTextDataAdapter(Context context, List<String> data, int numColumns) {
        this.mContext = context;
        this.mData = data;
        this.height = this.calculateHeight(context, numColumns);
    }

    public int getCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public String getItem(int position) {
        return this.mData == null ? null : this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View view, ViewGroup viewGroup) {
        Button button = new Button(this.mContext);
        button.setBackgroundResource(R.drawable.jwt_btn_bg_keys);
        button.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.jwt_input_soft_keys_text_color));
        button.setTextSize(1, 16.0f);
        button.setAllCaps(false);
        button.setFocusable(false);
        button.setClickable(false);
        button.setText((CharSequence)this.getItem(position));
        AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(-1, this.height);
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return button;
    }

    private int calculateHeight(Context context, int numColumns) {
        float scale = context.getResources().getDisplayMetrics().density;
        float parentHeight = 240.0f * scale + 0.5f;
        float padding = 4.0f * scale + 0.5f;
        int numRows = this.getCount() / numColumns + (this.getCount() % numColumns == 0 ? 0 : 1);
        return (int)(parentHeight / (float)numRows - padding);
    }
}

