/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextCallBack;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextDBUtils;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextDataAdapter;
import com.xdja.jwtcomponentslibrary.JWTEditText.JWTEditTextHistoryAdapter;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.IdCardUtils;
import com.xdja.jwtcomponentslibrary.utils.RegexUtils;
import com.xdja.jwtcomponentslibrary.utils.ToastUtils;
import com.xdja.jwtcomponentslibrary.utils.VibrationUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JWTEditTextInputSoft
implements View.OnClickListener,
View.OnLongClickListener,
TextWatcher,
View.OnTouchListener,
ViewPager.OnPageChangeListener {
    private Context mContext;
    private JWTEditTextCallBack mJWTEditTextCallBack;
    private int mThreshold;
    private int mSort;
    private String mDefaultText;
    private final List<String> tsclData = new ArrayList<String>();
    private final List<String> sfData = new ArrayList<String>();
    private final List<String> zmData = new ArrayList<String>();
    private final List<String> zm_yData = new ArrayList<String>();
    private final List<String> zm_xData = new ArrayList<String>();
    private final List<String> sfzData = new ArrayList<String>();
    private PopupWindow popupWindow;
    private View popupView;
    private TextView tsclTv;
    private TextView sfTv;
    private TextView zmTv;
    private TextView szTv;
    private RecyclerView listView;
    private JWTEditTextHistoryAdapter historyAdapter;
    private EditText clearEdit;
    private ViewPager viewPager;
    private List<View> views = new ArrayList<View>();
    private GridView tsclView;
    private GridView sfGridView;
    private GridView zmGridView;
    private GridView sfzGridView;
    private JWTEditTextDataAdapter zmAdapter;
    private JWTEditTextDBUtils dbUtils;
    private List<String> queryData;
    private final String UPPERCASE = "\u5927\u5199";
    private final String LOWERCASE = "\u5c0f\u5199";

    public JWTEditTextInputSoft(Context context) {
        this.mContext = context;
        this.initData();
        this.initPopupView();
        this.initPopupWindow();
        this.initGridViews();
        this.initPagerAdapter();
    }

    private void initPagerAdapter() {
        PagerAdapter pagerAdapter = new PagerAdapter(){

            public boolean isViewFromObject(View arg0, Object arg1) {
                return arg0 == arg1;
            }

            public int getCount() {
                return JWTEditTextInputSoft.this.views == null ? 0 : JWTEditTextInputSoft.this.views.size();
            }

            public void destroyItem(ViewGroup container, int position, Object view) {
                container.removeView((View)view);
            }

            public Object instantiateItem(ViewGroup collection, int position) {
                View view = (View)JWTEditTextInputSoft.this.views.get(position);
                collection.addView(view, 0);
                return view;
            }
        };
        this.viewPager.setOffscreenPageLimit(1);
        this.viewPager.setAdapter(pagerAdapter);
    }

    private void initGridViews() {
        for (int i = 0; i < 4; ++i) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_edittext_gridview, null);
            GridView gridView = (GridView)view.findViewById(R.id.soft_grid_view);
            gridView.setHorizontalSpacing(12);
            gridView.setVerticalSpacing(12);
            this.initGridView(gridView, i);
            this.views.add(view);
        }
    }

    private void initGridView(GridView gridView, int type) {
        switch (type) {
            case 0: {
                this.tsclView = gridView;
                this.tsclView.setNumColumns(3);
                JWTEditTextDataAdapter tsclAdapter = new JWTEditTextDataAdapter(this.mContext, this.tsclData, 3);
                this.tsclView.setAdapter((ListAdapter)tsclAdapter);
                break;
            }
            case 1: {
                this.sfGridView = gridView;
                this.sfGridView.setNumColumns(7);
                JWTEditTextDataAdapter sfAdapter = new JWTEditTextDataAdapter(this.mContext, this.sfData, 7);
                this.sfGridView.setAdapter((ListAdapter)sfAdapter);
                break;
            }
            case 2: {
                this.zmGridView = gridView;
                this.zmGridView.setNumColumns(6);
                this.zmData.addAll(this.zm_yData);
                this.zmAdapter = new JWTEditTextDataAdapter(this.mContext, this.zmData, 6);
                this.zmGridView.setAdapter((ListAdapter)this.zmAdapter);
                break;
            }
            case 3: {
                this.sfzGridView = gridView;
                this.sfzGridView.setNumColumns(3);
                JWTEditTextDataAdapter sfzAdapter = new JWTEditTextDataAdapter(this.mContext, this.sfzData, 3);
                this.sfzGridView.setAdapter((ListAdapter)sfzAdapter);
                break;
            }
        }
        if (this.tsclView != null) {
            this.tsclView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.tsclData.get(position));
                }
            });
        }
        if (this.sfGridView != null) {
            this.sfGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.sfData.get(position));
                }
            });
        }
        if (this.zmGridView != null) {
            this.zmGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    if ("\u5927\u5199".equals(JWTEditTextInputSoft.this.zmData.get(position))) {
                        JWTEditTextInputSoft.this.zmData.clear();
                        JWTEditTextInputSoft.this.zmData.addAll(JWTEditTextInputSoft.this.zm_yData);
                        JWTEditTextInputSoft.this.zmAdapter.notifyDataSetChanged();
                    } else if ("\u5c0f\u5199".equals(JWTEditTextInputSoft.this.zmData.get(position))) {
                        JWTEditTextInputSoft.this.zmData.clear();
                        JWTEditTextInputSoft.this.zmData.addAll(JWTEditTextInputSoft.this.zm_xData);
                        JWTEditTextInputSoft.this.zmAdapter.notifyDataSetChanged();
                    } else {
                        JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.zmData.get(position));
                    }
                }
            });
        }
        if (this.sfzGridView != null) {
            this.sfzGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    JWTEditTextInputSoft.this.setResult((String)JWTEditTextInputSoft.this.sfzData.get(position));
                }
            });
        }
    }

    private void initPopupView() {
        if (this.popupView == null) {
            this.popupView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_edittext_inputsoft, null);
            this.tsclTv = (TextView)this.popupView.findViewById(R.id.tscl_btn);
            this.sfTv = (TextView)this.popupView.findViewById(R.id.sf_btn);
            this.zmTv = (TextView)this.popupView.findViewById(R.id.zm_btn);
            this.szTv = (TextView)this.popupView.findViewById(R.id.sz_btn);
            ImageView delIv = (ImageView)this.popupView.findViewById(R.id.del_iv);
            Button copyBtn = (Button)this.popupView.findViewById(R.id.copy_btn);
            Button pasteBtn = (Button)this.popupView.findViewById(R.id.paste_btn);
            Button delBtn = (Button)this.popupView.findViewById(R.id.del_btn);
            Button confirmBtn = (Button)this.popupView.findViewById(R.id.confirm_btn);
            this.listView = (RecyclerView)this.popupView.findViewById(R.id.history_lsit);
            this.clearEdit = (EditText)this.popupView.findViewById(R.id.result_edit);
            this.viewPager = (ViewPager)this.popupView.findViewById(R.id.edit_viewpager);
            this.tsclTv.setOnClickListener((View.OnClickListener)this);
            this.sfTv.setOnClickListener((View.OnClickListener)this);
            this.zmTv.setOnClickListener((View.OnClickListener)this);
            this.szTv.setOnClickListener((View.OnClickListener)this);
            delIv.setOnClickListener((View.OnClickListener)this);
            delIv.setOnLongClickListener((View.OnLongClickListener)this);
            copyBtn.setOnClickListener((View.OnClickListener)this);
            delBtn.setOnClickListener((View.OnClickListener)this);
            delBtn.setOnLongClickListener((View.OnLongClickListener)this);
            confirmBtn.setOnClickListener((View.OnClickListener)this);
            pasteBtn.setOnClickListener((View.OnClickListener)this);
            this.clearEdit.setOnTouchListener((View.OnTouchListener)this);
            this.clearEdit.addTextChangedListener((TextWatcher)this);
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.clearEdit.setShowSoftInputOnFocus(false);
        }
    }

    private void initPopupWindow() {
        if (this.popupWindow == null) {
            this.popupWindow = new PopupWindow(this.popupView, -1, -1);
            this.popupWindow.setFocusable(true);
            this.popupWindow.setOutsideTouchable(true);
            this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1090519040));
            this.popupWindow.setSoftInputMode(16);
        }
    }

    private void initData() {
        String[] tsclDataArray = this.mContext.getResources().getStringArray(R.array.tscl);
        this.tsclData.addAll(Arrays.asList(tsclDataArray));
        String[] sfDataArray = this.mContext.getResources().getStringArray(R.array.sf);
        this.sfData.addAll(Arrays.asList(sfDataArray));
        String[] zmDataArray = this.mContext.getResources().getStringArray(R.array.zm_y);
        this.zm_yData.addAll(Arrays.asList(zmDataArray));
        String[] zmxDataArray = this.mContext.getResources().getStringArray(R.array.zm_x);
        this.zm_xData.addAll(Arrays.asList(zmxDataArray));
        String[] sfzDataArray = this.mContext.getResources().getStringArray(R.array.sfz);
        this.sfzData.addAll(Arrays.asList(sfzDataArray));
    }

    public void setCallBack(JWTEditTextCallBack callBack) {
        this.mJWTEditTextCallBack = callBack;
    }

    public void setSort(int sort) {
        this.mSort = sort;
    }

    public void setThreshold(int threshold) {
        this.mThreshold = threshold;
    }

    public void showInputSoft(int inputType, String defaultText, String hint) {
        this.mDefaultText = defaultText;
        this.clearEdit.setText((CharSequence)defaultText);
        this.clearEdit.setSelection(defaultText.length());
        this.clearEdit.setHint((CharSequence)hint);
        this.viewPager.setCurrentItem(inputType);
        if (this.popupWindow != null && this.popupView != null) {
            this.popupWindow.showAtLocation(this.popupView.getRootView(), 80, 0, 0);
        }
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.copy_btn) {
            this.vibrate();
            this.copyAction();
        } else if (i == R.id.del_iv || i == R.id.del_btn) {
            this.vibrate();
            this.delAction();
        } else if (i == R.id.confirm_btn) {
            this.vibrate();
            this.confirmAction(this.clearEdit.getText().toString());
        } else if (i == R.id.paste_btn) {
            this.vibrate();
            this.pasteAction();
        } else if (i == R.id.tscl_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(0);
        } else if (i == R.id.sf_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(1);
        } else if (i == R.id.zm_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(2);
        } else if (i == R.id.sz_btn) {
            this.vibrate();
            this.viewPager.setCurrentItem(3);
        }
    }

    private void dismiss() {
        if (this.dbUtils != null) {
            this.dbUtils.closeDatabase();
            this.dbUtils = null;
        }
        this.popupWindow.dismiss();
    }

    private void pasteAction() {
        ClipboardManager cmb = (ClipboardManager)this.mContext.getSystemService("clipboard");
        if (cmb != null && null != cmb.getPrimaryClip()) {
            String text = cmb.getPrimaryClip().getItemAt(0).getText().toString();
            this.clearEdit.append((CharSequence)text);
        }
    }

    private void confirmAction(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            if (this.mSort == 0 && !RegexUtils.isMatch("(^[\\u4e00-\\u9fa5][A-Z][A-Z0-9]{4}[A-Z0-9\u6e2f\u6fb3\u5b66\u6302\u8bd5\u8d85\u8b66\u9886]$)|(^[\\u4e00-\\u9fa5][A-Z](([DF](?![IO])[A-Z0-9][0-9]{4})|([0-9]{5}[DF]))$)|(^[0-9]{3}[A-Z0-9]{3}[\u4f7f\u9886]$)|(^WJ[\\u4e00-\\u9fa5][A-Z0-9]{4}[0-9XBTSHJD]$)", content)) {
                this.showToast("\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                return;
            }
            if (this.mSort == 1) {
                if (!RegexUtils.isMatch("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)", content)) {
                    this.showToast("\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                    return;
                }
                if (!IdCardUtils.isIdentityCode(content)) {
                    this.showToast("\u8eab\u4efd\u8bc1\u6821\u9a8c\u7801\u65e0\u6548\uff0c\u4e0d\u662f\u5408\u6cd5\u7684\u8eab\u4efd\u8bc1\u53f7\u7801");
                    return;
                }
            }
            if (this.dbUtils == null) {
                this.dbUtils = new JWTEditTextDBUtils(this.mContext);
            }
            this.dbUtils.saveHistory(content);
        }
        if (this.mJWTEditTextCallBack != null) {
            this.mJWTEditTextCallBack.onConfirm(content);
        }
        this.dismiss();
    }

    private void delAction() {
        String text = this.clearEdit.getText().toString();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        int selection = this.clearEdit.getSelectionStart();
        if (selection <= 0) {
            return;
        }
        this.clearEdit.setText((CharSequence)String.format("%s%s", text.substring(0, selection - 1), text.substring(selection)));
        this.clearEdit.setSelection(selection - 1);
    }

    private void copyAction() {
        ClipboardManager cmb = (ClipboardManager)this.mContext.getSystemService("clipboard");
        if (cmb != null) {
            cmb.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)this.clearEdit.getText().toString()));
            this.showToast("\u5df2\u7ecf\u590d\u5236\u5230\u7c98\u8d34\u677f\uff01");
        }
    }

    public boolean onLongClick(View view) {
        this.clearEdit.setText((CharSequence)"");
        return true;
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
        if (TextUtils.isEmpty((CharSequence)editable.toString())) {
            this.listView.setVisibility(8);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDefaultText)) {
            this.listView.setVisibility(8);
            this.mDefaultText = "";
            return;
        }
        if (editable.length() > this.mThreshold) {
            List<String> result;
            if (this.dbUtils == null) {
                this.dbUtils = new JWTEditTextDBUtils(this.mContext);
            }
            if ((result = this.dbUtils.query(editable.toString())) == null || result.size() == 0) {
                this.listView.setVisibility(8);
            } else {
                this.queryData = result;
                this.listView.setVisibility(0);
                if (this.historyAdapter == null) {
                    this.listView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 0, false));
                    this.listView.setHasFixedSize(true);
                    this.listView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
                    this.historyAdapter = new JWTEditTextHistoryAdapter(this.queryData, new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                            if (JWTEditTextInputSoft.this.queryData != null && JWTEditTextInputSoft.this.queryData.size() > position) {
                                JWTEditTextInputSoft.this.confirmAction((String)JWTEditTextInputSoft.this.queryData.get(position));
                            }
                        }
                    });
                    this.listView.setAdapter((RecyclerView.Adapter)this.historyAdapter);
                } else {
                    this.historyAdapter.updateData(this.queryData);
                }
            }
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        EditText et = (EditText)view;
        Class<EditText> cls = EditText.class;
        try {
            Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
            setShowSoftInputOnFocus.setAccessible(false);
            setShowSoftInputOnFocus.invoke((Object)et, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        et.onTouchEvent(motionEvent);
        return true;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (position == 0) {
            this.tsclTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.zmTv.setBackground(null);
            this.szTv.setBackground(null);
            this.sfTv.setBackground(null);
        } else if (position == 1) {
            this.sfTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.zmTv.setBackground(null);
            this.szTv.setBackground(null);
            this.tsclTv.setBackground(null);
        } else if (position == 2) {
            this.zmTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.sfTv.setBackground(null);
            this.szTv.setBackground(null);
            this.tsclTv.setBackground(null);
        } else if (position == 3) {
            this.szTv.setBackgroundResource(R.drawable.jwt_btn_select);
            this.sfTv.setBackground(null);
            this.zmTv.setBackground(null);
            this.tsclTv.setBackground(null);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void showToast(String message) {
        ToastUtils.showShortToast(this.mContext, message);
    }

    private void vibrate() {
        this.vibrate(20L);
    }

    private void vibrate(long milliseconds) {
        VibrationUtils.vibrate(this.mContext, milliseconds);
    }

    private void setResult(String input) {
        int selection = this.clearEdit.getSelectionStart();
        String text = this.clearEdit.getText().toString();
        this.clearEdit.setText((CharSequence)String.format("%s%s%s", text.substring(0, selection), input, text.substring(selection)));
        this.clearEdit.setSelection(selection + input.length());
    }
}

