/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;
import com.xdja.jwtcomponentslibrary.R;
import java.util.Locale;

@SuppressLint(value={"AppCompatCustomView"})
public class LabelSeekBar
extends SeekBar {
    private int[] position;
    private PopupWindow labelPopupWindow;
    private TextView label;
    private View labelView;

    public LabelSeekBar(Context context) {
        this(context, null);
    }

    public LabelSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LabelSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.labelView = LayoutInflater.from((Context)context).inflate(R.layout.jwt_label_seekbar, null);
        this.label = (TextView)this.labelView.findViewById(R.id.label_text);
        this.labelPopupWindow = new PopupWindow(this.labelView, -2, -2);
        this.position = new int[2];
    }

    public void showLabel(View view) {
        if (this.label == null || this.labelPopupWindow == null) {
            return;
        }
        int progress = this.getProgress();
        this.label.setText((CharSequence)String.format(Locale.getDefault(), "%d%%", progress));
        this.getLocationInWindow(this.position);
        int thumbX = (int)((float)progress * ((float)this.getWidth() * 1.0f / ((float)this.getMax() * 1.0f)));
        int x = thumbX + this.position[0] - this.getViewWidth(this.labelView) / 2;
        int y = this.position[1] - this.getViewHeight(this.labelView) - this.getContext().getResources().getDimensionPixelOffset(R.dimen.padding_4);
        if (this.labelPopupWindow.isShowing()) {
            this.labelPopupWindow.update(x, y, this.getViewWidth(this.labelView), this.getViewHeight(this.labelView));
        } else {
            this.labelPopupWindow.showAtLocation(view, 0, x, y);
        }
    }

    public void hideLabel() {
        if (this.labelPopupWindow == null || !this.labelPopupWindow.isShowing()) {
            return;
        }
        this.labelPopupWindow.dismiss();
    }

    private int getViewWidth(View v) {
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        v.measure(w, h);
        return v.getMeasuredWidth();
    }

    private int getViewHeight(View v) {
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        v.measure(w, h);
        return v.getMeasuredHeight();
    }
}

