package com.xdja.jwtcomponentslibrary.JWTAutoComplete;

import android.content.Context;
import android.content.res.Resources;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.util.AttributeSet;

import com.xdja.jwtcomponentslibrary.R;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by wanjing on 2017/9/5.
 *
 * desc: 警务通AutoComplete组件。
 */

public class JWTAutoComplete<T> extends AppCompatAutoCompleteTextView {

    private Context mContext;

    private JWTAutoCompleteSearchAdapter<T> searchAdapter;
    private List<T> mData = new ArrayList<>();

    private boolean showAllData = false;

    public JWTAutoComplete(Context context) {
        this(context, null);
    }

    public JWTAutoComplete(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public JWTAutoComplete(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;

        // 获取属性值
//        TypedArray typedArray = mContext
//                .obtainStyledAttributes(attrs, R.styleable.JWTAutoComplete);
//        if (typedArray != null) {
//            typedArray.recycle();
//        }

        // 初始化设置
        setSingleLine(true);

        Resources resources = mContext.getResources();
        int padding = resources.getDimensionPixelOffset(R.dimen.padding_8);
        setPadding(padding, padding, padding, padding);
//        setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        setMinHeight(resources.getDimensionPixelOffset(R.dimen.min_height));
        setBackgroundResource(R.drawable.jwt_edittext_bg_selector);
    }

    /**
     * 初始化适配器
     */
    public void initAdapter() {
        searchAdapter = new JWTAutoCompleteSearchAdapter<>(getContext(),
                android.R.layout.simple_list_item_1, mData, JWTAutoCompleteSearchAdapter.ALL);
        setAdapter(searchAdapter);
    }

    public void setData(T[] data) {
        this.mData = Arrays.asList(data);

        initAdapter();
    }

    public void setData(List<T> data) {
        this.mData = data;

        initAdapter();
    }

    public T getItem(int position) {
        return searchAdapter.getItem(position);
    }

    public int getPosition(T item) {
        return searchAdapter.getPosition(item);
    }

    public boolean isShowAllData() {
        return showAllData;
    }

    public void setShowAllData(boolean showAllData) {
        this.showAllData = showAllData;
    }

    @Override
    public boolean enoughToFilter() {
        // 关键代码，确保用户没有输入的时候显示全部数据
        return showAllData || super.enoughToFilter();
    }
}
