package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

/**
 * Created by wanjing on 2017/8/30.
 *
 * desc：警务通输入法数据库帮助类。
 */

public class JWTEditTextDBHelper extends SQLiteOpenHelper {

    private static final String DBName = "jwt_edittext_history_item.db";

    private static final int DBVersion = 1;

    public JWTEditTextDBHelper(Context context) {
        this(context, DBName, null, DBVersion);
    }

    public JWTEditTextDBHelper(Context context, String name, SQLiteDatabase.CursorFactory factory,
                               int version) {
        this(context, name, factory, version, null);
    }

    public JWTEditTextDBHelper(Context context, String name, SQLiteDatabase.CursorFactory factory,
                               int version, DatabaseErrorHandler errorHandler) {
        super(context, name, factory, version, errorHandler);
    }

    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        // 创建历史记录表
        sqLiteDatabase.execSQL("create table t_history(c_id int primary key, c_content varchar(100), c_time long);");
    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {

    }
}
