package com.xdja.jwtcomponentslibrary.JWTEditText;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.ConstUtils;
import com.xdja.jwtcomponentslibrary.utils.IdCardUtils;
import com.xdja.jwtcomponentslibrary.utils.RegexUtils;
import com.xdja.jwtcomponentslibrary.utils.ToastUtils;
import com.xdja.jwtcomponentslibrary.utils.VibrationUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author wanjing
 * @date 2017/8/29
 *
 * 警务通输入法控件
 */

public class JWTEditTextInputSoft implements View.OnClickListener, View.OnLongClickListener,
        TextWatcher, View.OnTouchListener, ViewPager.OnPageChangeListener {

    private Context mContext;

    private JWTEditTextCallBack mJWTEditTextCallBack;

    /**阈值，大于该阈值则显示历史记录(默认值2)*/
    private int mThreshold;

    /**类别，用于校验输入是否合法*/
    private int mSort;

    /**默认文本*/
    private String mDefaultText;

    private final List<String> tsclData = new ArrayList<>();
    private final List<String> sfData = new ArrayList<>();
    private final List<String> zmData = new ArrayList<>();
    private final List<String> zm_yData = new ArrayList<>();
    private final List<String> zm_xData = new ArrayList<>();
    private final List<String> sfzData = new ArrayList<>();

    private PopupWindow popupWindow;

    private View popupView;
    private TextView tsclTv, sfTv, zmTv, szTv;
    private RecyclerView listView;
    private JWTEditTextHistoryAdapter historyAdapter;
    private EditText clearEdit;
    private ViewPager viewPager;

    private List<View> views = new ArrayList<>();
    /**特殊车辆*/
    private GridView tsclView;
    /**省份*/
    private GridView sfGridView;
    /**字母*/
    private GridView zmGridView;
    /**数字*/
    private GridView sfzGridView;
    private JWTEditTextDataAdapter zmAdapter;

    /**数据库操作工具类*/
    private JWTEditTextDBUtils dbUtils;

    /**根据关键字查询到的历史记录*/
    private List<String> queryData;

    private final String UPPERCASE = "大写";
    private final String LOWERCASE = "小写";

    public JWTEditTextInputSoft(Context context) {
        this.mContext = context;
        initData();
        initPopupView();
        initPopupWindow();
        initGridViews();
        initPagerAdapter();
    }

    private void initPagerAdapter() {
        PagerAdapter pagerAdapter = new PagerAdapter() {
            @Override
            public boolean isViewFromObject(View arg0, Object arg1) {
                return arg0 == arg1;
            }

            @Override
            public int getCount() {
                return views == null ? 0 : views.size();
            }

            @Override
            public void destroyItem(ViewGroup container, int position, Object view) {
                container.removeView((View) view);
            }

            @Override
            public Object instantiateItem(ViewGroup collection, int position) {
                View view = views.get(position);
                collection.addView(view, 0);
                return view;
            }
        };
        viewPager.setOffscreenPageLimit(1);
        viewPager.setAdapter(pagerAdapter);
    }

    private void initGridViews() {
        for (int i = 0; i < 4; i++){
            View view = LayoutInflater.from(mContext)
                    .inflate(R.layout.jwt_edittext_gridview, null);
            GridView gridView = view.findViewById(R.id.soft_grid_view);
            gridView.setHorizontalSpacing(12);
            gridView.setVerticalSpacing(12);
            initGridView(gridView, i);
            views.add(view);
        }
    }

    private void initGridView(GridView gridView, int type) {
        switch (type){
            case 0:
                this.tsclView = gridView;
                this.tsclView.setNumColumns(3);
                JWTEditTextDataAdapter tsclAdapter = new JWTEditTextDataAdapter(mContext, tsclData, 3);
                this.tsclView.setAdapter(tsclAdapter);
                break;
            case 1:
                this.sfGridView = gridView;
                this.sfGridView.setNumColumns(7);
                JWTEditTextDataAdapter sfAdapter = new JWTEditTextDataAdapter(mContext, sfData, 7);
                this.sfGridView.setAdapter(sfAdapter);
                break;
            case 2:
                this.zmGridView = gridView;
                this.zmGridView.setNumColumns(6);
                zmData.addAll(zm_yData);
                zmAdapter = new JWTEditTextDataAdapter(mContext, zmData, 6);
                this.zmGridView.setAdapter(zmAdapter);
                break;
            case 3:
                this.sfzGridView = gridView;
                this.sfzGridView.setNumColumns(3);
                JWTEditTextDataAdapter sfzAdapter = new JWTEditTextDataAdapter(mContext, sfzData, 3);
                this.sfzGridView.setAdapter(sfzAdapter);
                break;
            default:
                break;
        }
        if (this.tsclView != null){
            this.tsclView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    vibrate();
                    setResult(tsclData.get(position));
                }
            });
        }
        if (this.sfGridView != null){
            this.sfGridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    vibrate();
                    setResult(sfData.get(position));
                }
            });
        }
        if (this.zmGridView != null){
            this.zmGridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    vibrate();
                    if (UPPERCASE.equals(zmData.get(position))){
                        zmData.clear();
                        zmData.addAll(zm_yData);
                        zmAdapter.notifyDataSetChanged();
                    } else if (LOWERCASE.equals(zmData.get(position))){
                        zmData.clear();
                        zmData.addAll(zm_xData);
                        zmAdapter.notifyDataSetChanged();
                    } else {
                        setResult(zmData.get(position));
                    }
                }
            });
        }
        if (this.sfzGridView != null){
            this.sfzGridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    vibrate();
                    setResult(sfzData.get(position));
                }
            });
        }
    }

    private void initPopupView() {
        if (popupView == null) {
            popupView = LayoutInflater.from(mContext).inflate(R.layout.jwt_edittext_inputsoft, null);
            tsclTv = popupView.findViewById(R.id.tscl_btn);
            sfTv = popupView.findViewById(R.id.sf_btn);
            zmTv = popupView.findViewById(R.id.zm_btn);
            szTv = popupView.findViewById(R.id.sz_btn);
            ImageView delIv = popupView.findViewById(R.id.del_iv);
            Button copyBtn = popupView.findViewById(R.id.copy_btn);
            Button pasteBtn = popupView.findViewById(R.id.paste_btn);
            Button delBtn = popupView.findViewById(R.id.del_btn);
            Button confirmBtn = popupView.findViewById(R.id.confirm_btn);
            listView = popupView.findViewById(R.id.history_lsit);
            clearEdit = popupView.findViewById(R.id.result_edit);
            viewPager = popupView.findViewById(R.id.edit_viewpager);
            tsclTv.setOnClickListener(this);
            sfTv.setOnClickListener(this);
            zmTv.setOnClickListener(this);
            szTv.setOnClickListener(this);
            delIv.setOnClickListener(this);
            delIv.setOnLongClickListener(this);
            copyBtn.setOnClickListener(this);
            delBtn.setOnClickListener(this);
            delBtn.setOnLongClickListener(this);
            confirmBtn.setOnClickListener(this);
            pasteBtn.setOnClickListener(this);
            clearEdit.setOnTouchListener(this);
            clearEdit.addTextChangedListener(this);
            viewPager.addOnPageChangeListener(this);

            // Android版本是5.0以上，此方法生效。隐藏输入法且有光标
            clearEdit.setShowSoftInputOnFocus(false);
        }
    }

    private void initPopupWindow() {
        if (popupWindow == null) {
            popupWindow = new PopupWindow(popupView, ViewGroup.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.MATCH_PARENT);
            popupWindow.setFocusable(true);
            popupWindow.setOutsideTouchable(true);
            popupWindow.setBackgroundDrawable(new ColorDrawable(0xbf000000));
            popupWindow
                    .setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
        }
    }

    private void initData() {
        String[] tsclDataArray = mContext.getResources().getStringArray(R.array.tscl);
        tsclData.addAll(Arrays.asList(tsclDataArray));
        String[] sfDataArray = mContext.getResources().getStringArray(R.array.sf);
        sfData.addAll(Arrays.asList(sfDataArray));
        String[] zmDataArray = mContext.getResources().getStringArray(R.array.zm_y);
        zm_yData.addAll(Arrays.asList(zmDataArray));
        String[] zmxDataArray = mContext.getResources().getStringArray(R.array.zm_x);
        zm_xData.addAll(Arrays.asList(zmxDataArray));
        String[] sfzDataArray = mContext.getResources().getStringArray(R.array.sfz);
        sfzData.addAll(Arrays.asList(sfzDataArray));
    }

    public void setCallBack(JWTEditTextCallBack callBack) {
        this.mJWTEditTextCallBack = callBack;
    }

    public void setSort(int sort) {
        this.mSort = sort;
    }

    public void setThreshold(int threshold) {
        this.mThreshold = threshold;
    }

    public void showInputSoft(int inputType, String defaultText, String hint) {
        this.mDefaultText = defaultText;

        clearEdit.setText(defaultText);
        clearEdit.setSelection(defaultText.length());
        clearEdit.setHint(hint);

        viewPager.setCurrentItem(inputType);

        if (popupWindow != null && popupView != null) {
            popupWindow.showAtLocation(popupView.getRootView(), Gravity.BOTTOM, 0, 0);
        }
    }

    @Override
    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.copy_btn) {
            vibrate();
            copyAction();

        } else if (i == R.id.del_iv || i == R.id.del_btn) {
            vibrate();
            delAction();

        } else if (i == R.id.confirm_btn) {
            vibrate();
            confirmAction(clearEdit.getText().toString());

        } else if (i == R.id.paste_btn) {
            vibrate();
            pasteAction();

        } else if (i == R.id.tscl_btn) {
            vibrate();
            viewPager.setCurrentItem(0);

        } else if (i == R.id.sf_btn) {
            vibrate();
            viewPager.setCurrentItem(1);

        } else if (i == R.id.zm_btn) {
            vibrate();
            viewPager.setCurrentItem(2);

        } else if (i == R.id.sz_btn) {
            vibrate();
            viewPager.setCurrentItem(3);

        }
    }

    /**
     * 释放资源，关闭数据库，dismiss popupWindow。
     */
    private void dismiss() {
        if (dbUtils != null) {
            dbUtils.closeDatabase();
            dbUtils = null;
        }
        popupWindow.dismiss();
    }

    /**
     * 黏贴操作
     */
    private void pasteAction() {
        ClipboardManager cmb = (ClipboardManager) mContext.getSystemService(Context.CLIPBOARD_SERVICE);
        if (cmb != null) {
            if (null!=cmb.getPrimaryClip()) {
                String text = cmb.getPrimaryClip().getItemAt(0).getText().toString();
                clearEdit.append(text);
            }
        }
    }

    /**
     * 确定操作
     *
     * @param content 输入内容
     */
    private void confirmAction(String content) {
        // 非空校验
        if (!TextUtils.isEmpty(content)) {
            // 校验输入是否合法 0-车牌号 1-身份证号
            if (mSort == 0) {
                if (!RegexUtils.isMatch(ConstUtils.REGEX_NUMBER_PLATE, content)) {
                    showToast("格式有误，请重新输入");
                    return;
                }
            }
            if (mSort == 1) {
                if (!RegexUtils.isMatch(ConstUtils.REGEX_NUMBER_IDCARD, content)) {
                    showToast("格式有误，请重新输入");
                    return;
                }
                if (!IdCardUtils.isIdentityCode(content)) {
                    showToast("身份证校验码无效，不是合法的身份证号码");
                    return;
                }
            }

            if (dbUtils == null) {
                dbUtils = new JWTEditTextDBUtils(mContext);
            }
            dbUtils.saveHistory(content);
        }

        if (mJWTEditTextCallBack != null) {
            mJWTEditTextCallBack.onConfirm(content);
        }
        dismiss();
    }

    /**
     * 删除操作
     */
    private void delAction() {
        String text = clearEdit.getText().toString();
        if (TextUtils.isEmpty(text)){
            return;
        }
        int selection = clearEdit.getSelectionStart();
        if (selection <= 0) {
            return;
        }
        clearEdit.setText(String.format("%s%s",
                text.substring(0, selection - 1), text.substring(selection)));
        clearEdit.setSelection(selection - 1);
    }

    /**
     * 复制到粘贴板
     */
    private void copyAction() {
        ClipboardManager cmb = (ClipboardManager) mContext.getSystemService(Context.CLIPBOARD_SERVICE);
        if (cmb != null) {
            cmb.setPrimaryClip(ClipData.newPlainText(null, clearEdit.getText().toString()));
            showToast("已经复制到粘贴板！");
        }
    }

    @Override
    public boolean onLongClick(View view) {
        clearEdit.setText("");
        return true;
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void afterTextChanged(Editable editable) {
        if (TextUtils.isEmpty(editable.toString())) {
            listView.setVisibility(View.GONE);
            return;
        }
        if (!TextUtils.isEmpty(mDefaultText)) {
            listView.setVisibility(View.GONE);
            mDefaultText = "";
            return;
        }
        if (editable.length() > mThreshold) {
            if (dbUtils == null) {
                dbUtils = new JWTEditTextDBUtils(mContext);
            }
            List<String> result = dbUtils.query(editable.toString());
            if (result == null || result.size() == 0) {
                listView.setVisibility(View.GONE);
            } else {
                queryData = result;
                listView.setVisibility(View.VISIBLE);
                if (historyAdapter == null) {
                    listView.setLayoutManager(new LinearLayoutManager(mContext,
                            OrientationHelper.HORIZONTAL, false));
                    listView.setHasFixedSize(true);
                    listView.setItemAnimator(new DefaultItemAnimator());
                    historyAdapter = new JWTEditTextHistoryAdapter(queryData, new AdapterView.OnItemClickListener() {
                        @Override
                        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                            if (queryData != null && queryData.size() > position) {
                                confirmAction(queryData.get(position));
                            }
                        }
                    });
                    listView.setAdapter(historyAdapter);
                } else {
                    historyAdapter.updateData(queryData);
                }
            }
        }
    }

    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        //隐藏系统输入法，显示光标
        EditText et = (EditText) view;
        // back up the input type
        Class<EditText> cls = EditText.class;
        try {
            Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", boolean.class);
            setShowSoftInputOnFocus.setAccessible(false);
            setShowSoftInputOnFocus.invoke(et, false);
        } catch (NoSuchMethodException | IllegalArgumentException
                | IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        // call native handler
        et.onTouchEvent(motionEvent);
        return true;
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

    }

    @Override
    public void onPageSelected(int position) {
        if (position == 0){
            tsclTv.setBackgroundResource(R.drawable.jwt_btn_select);
            zmTv.setBackground(null);
            szTv.setBackground(null);
            sfTv.setBackground(null);
        } else if (position == 1){
            sfTv.setBackgroundResource(R.drawable.jwt_btn_select);
            zmTv.setBackground(null);
            szTv.setBackground(null);
            tsclTv.setBackground(null);
        } else if (position == 2){
            zmTv.setBackgroundResource(R.drawable.jwt_btn_select);
            sfTv.setBackground(null);
            szTv.setBackground(null);
            tsclTv.setBackground(null);
        } else if (position == 3){
            szTv.setBackgroundResource(R.drawable.jwt_btn_select);
            sfTv.setBackground(null);
            zmTv.setBackground(null);
            tsclTv.setBackground(null);
        }
    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }

    /**
     * 展示吐司
     *
     * @param message 展示内容
     */
    private void showToast(String message) {
        ToastUtils.showShortToast(mContext, message);
    }

    /**
     * 震动，默认震动20ms
     */
    private void vibrate() {
        vibrate(20);
    }

    /**
     * 震动
     *
     * @param milliseconds 震动时长
     */
    private void vibrate(long milliseconds) {
        VibrationUtils.vibrate(mContext, milliseconds);
    }

    /**
     * 输入文本
     *
     * @param input 输入内容
     */
    private void setResult(String input) {
        int selection = clearEdit.getSelectionStart();
        String text = clearEdit.getText().toString();
        clearEdit.setText(String.format("%s%s%s", text.substring(0, selection), input, text.substring(selection)));
        clearEdit.setSelection(selection + input.length());
    }
}
