package com.xdja.jwtcomponentslibrary.JWTSpinner;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageButton;

import com.xdja.jwtcomponentslibrary.JWTAutoComplete.JWTAutoComplete;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.KeyboardUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wanjing
 * @date 2017/9/5
 * @see JWTSpinnerV1
 *
 * 警务通spinner组件, 支持搜索。
 */
@Deprecated
public class JWTSpinner extends FrameLayout
        implements AdapterView.OnItemSelectedListener, AdapterView.OnItemClickListener, View.OnClickListener {

    private Context mContext;

    private JWTAutoComplete<String> autoComplete;
    private ImageButton imageButton;

    private List<JWTSpinnerDataItemBean> mDataItemBeen = new ArrayList<>();
    private List<String> mTexts = new ArrayList<>();
    private List<String> mValues = new ArrayList<>();

    private JWTSpinnerCallBack mCallBack;

    /**选择的文本*/
    private String selectedText = "";
    /**选择的值*/
    private String selectedValue = "";

    private String defaultTextOrValue;
    private int background;
    private int textColor;
    private int textSize;
    private int imageBtnBackground;

    public JWTSpinner(Context context) {
        this(context, null);
    }

    public JWTSpinner(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);

        init(context, attrs);
    }

    public JWTSpinner(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;

        TypedArray ta = mContext.obtainStyledAttributes(attrs, R.styleable.JWTSpinner);
        if (ta != null) {
            defaultTextOrValue = ta.getString(R.styleable.JWTSpinner_default_value);
            background = ta.getResourceId(R.styleable.JWTSpinner_spinner_background,
                    R.drawable.jwt_edittext_bg_selector);
            textColor = ta.getColor(R.styleable.JWTSpinner_spinner_text_color,
                    getResources().getColor(R.color.spinner_default_text_color));
            textSize = ta.getDimensionPixelSize(R.styleable.JWTSpinner_spinner_text_size,
                    getResources().getDimensionPixelSize(R.dimen.spinner_default_text_size));
            imageBtnBackground = ta.getResourceId(R.styleable.JWTSpinner_spinner_dropdown_btn_background,
                    R.drawable.jwt_sp_btn_selector);
            ta.recycle();
        }

        LayoutInflater.from(mContext).inflate(R.layout.jwt_spinner, this);
        autoComplete = findViewById(R.id.jwt_spinner_autocomplete);
        imageButton = findViewById(R.id.jwt_spinner_imgbtn);

        autoComplete.setBackgroundResource(background);
        autoComplete.setTextColor(textColor);
        autoComplete.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
        autoComplete.setThreshold(1);
        //目前底层只有接口，没有实现
        autoComplete.setOnItemSelectedListener(this);
        autoComplete.setOnItemClickListener(this);

        imageButton.setBackgroundResource(imageBtnBackground);
        imageButton.setOnClickListener(this);
    }

    /**
     * 设置数据
     *
     * @param dataItemBeen 数据
     */
    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen) {
        setData(dataItemBeen, defaultTextOrValue);
    }

    /**
     * 设置数据和默认文本
     *
     * @param dataItemBeen 数据
     * @param defaultTextOrValue 默认文本/默认值
     */
    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen, String defaultTextOrValue) {
        if (dataItemBeen == null || dataItemBeen.size() == 0) {
            return;
        }
        this.mDataItemBeen = dataItemBeen;

        for (int i = 0; i < mDataItemBeen.size(); i++) {
            mTexts.add(i, mDataItemBeen.get(i).getText());
            mValues.add(i, mDataItemBeen.get(i).getValue());
        }

        autoComplete.setData(mTexts);

        setDefaultValue(defaultTextOrValue);
    }

    /**
     * 设置默认文本
     *
     * @param defaultTextOrValue 默认文本/默认值
     */
    public void setDefaultValue(@NonNull String defaultTextOrValue) {
        String defaultText;
        int index = mTexts.indexOf(defaultTextOrValue);
        if (index == -1) {
            index = mValues.indexOf(defaultTextOrValue);
            if (index == -1) {
                selectedText = defaultText = "";
                selectedValue = "";
            } else {
                selectedText = defaultText = mTexts.get(index);
                selectedValue = mValues.get(index);
            }
        } else {
            selectedText = defaultText = mTexts.get(index);
            selectedValue = mValues.get(index);
        }

        autoComplete.setText(defaultText);
        autoComplete.setSelection(defaultText.length());
    }

    public void setCallBack(JWTSpinnerCallBack callBack) {
        this.mCallBack = callBack;
    }

    public String getSelectedText() {
        return selectedText;
    }

    private void setSelectedText(String selectedText) {
        this.selectedText = selectedText;
    }

    public String getSelectedValue() {
        return selectedValue;
    }

    private void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    /**
     * 判断用户输入的文本是否是有效/合理的值
     *
     * @return true, 有效/合理；false, 无效/不合理。
     */
    public boolean isInputValid() {
        return getSelectedPosition() != -1;
    }

    /**
     * 获取用户输入的文本在 Spinner数据集 中的位置
     *
     * @return 输入不合理时，返回-1。
     */
    public int getSelectedPosition() {
        return mTexts.indexOf(autoComplete.getText().toString());
    }

    public String getTextByValue(String text) {
        int index = mTexts.indexOf(text);
        if (index == -1) {
            return null;
        } else {
            return mValues.get(index);
        }
    }

    public String getValueByText(String value) {
        int index = mValues.indexOf(value);
        if (index == -1) {
            return null;
        } else {
            return mTexts.get(index);
        }
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        if (mDataItemBeen == null || mDataItemBeen.size() <= position) {
            return;
        }
        setSelectedText(mDataItemBeen.get(position).getText());
        setSelectedValue(mDataItemBeen.get(position).getValue());
        if (mCallBack != null) {
            mCallBack.onItemSelected(getSelectedText(), getSelectedValue());
        }
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
        setSelectedText("");
        setSelectedValue("");
        if (mCallBack != null) {
            mCallBack.onNothingSelected();
        }
    }

    @Override
    public void onClick(View v) {
        // add by wanjing on 2017/10/23 17:14
        // 如果autoComplete没获取到焦点，那么autoComplete.setText("")则是无用的。
        if (!autoComplete.hasFocus()) {
            autoComplete.requestFocus();
        }
        // end add on 2017/10/23 17:14.
        autoComplete.setShowAllData(true);
        // 关键代码，显示全部数据
        autoComplete.setText("");

        //关闭系统输入法
        KeyboardUtils.hideSoftInput(mContext, this);
    }

    public JWTAutoComplete<String> getAutoComplete() {
        return autoComplete;
    }

    public ImageButton getImageButton() {
        return imageButton;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        onItemSelected(parent, view, position, id);
    }
}
