package com.xdja.jwtcomponentslibrary.JWTSpinner;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.xdja.jwtcomponentslibrary.JWTAutoComplete.JWTAutoCompleteSearchAdapter;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.KeyboardUtils;

import java.io.Serializable;
import java.lang.reflect.Field;

/**
 * @author wanjing
 * @date 2018/3/1
 */
public class JWTSpinnerV1DialogView extends AlertDialog implements SearchView.OnQueryTextListener {

    private Context mContext;

    private SearchView searchView;
    private ListView listView;
    private JWTAutoCompleteSearchAdapter<String> listAdapter;

    private SearchItemClickCallBack<String> searchItemClickCallBack;

    public JWTSpinnerV1DialogView(Context context, String[] items, int threshold) {
        super(context);

        init(context, items, threshold);
    }

    private void init(Context context, String[] items, int threshold) {
        this.mContext = context;

        View rootView = LayoutInflater.from(mContext)
                .inflate(R.layout.jwt_spinner_v1_dialog_view, null);
        setData(rootView, items, threshold);
        setCursorIcon();
        setListener();
        setView(rootView);

        Window window = getWindow();
        if (window != null) {
            window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
        }
    }

    private void setListener() {
        setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                searchView.setQuery("", false);
            }
        });
    }

    private void setCursorIcon() {
        try {
            Class cls = Class.forName("android.support.v7.widget.SearchView");
            Field field = cls.getDeclaredField("mSearchSrcTextView");
            field.setAccessible(true);

            TextView tv = (TextView) field.get(searchView);
            Class[] classes = cls.getDeclaredClasses();
            for (Class cls_ : classes) {
                if (cls_.toString().endsWith("android.support.v7.widget.SearchView$SearchAutoComplete")) {
                    Class targetCls = cls_.getSuperclass().getSuperclass().getSuperclass().getSuperclass();
                    Field cursorIconField = targetCls.getDeclaredField("mCursorDrawableRes");
                    cursorIconField.setAccessible(true);
                    cursorIconField.set(tv, R.drawable.jwt_edittext_cursor);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 按照ui标准修改搜索视图
     */
    private void modifySearchView() {
        //调整搜索图标宽度
        ImageView magImage = searchView.findViewById(R.id.search_mag_icon);
        ViewGroup.LayoutParams magImageLayoutParams = magImage.getLayoutParams();
        magImageLayoutParams.width = ViewGroup.LayoutParams.WRAP_CONTENT;
        magImage.setLayoutParams(magImageLayoutParams);
        //隐藏下划线
        View searchPlate = searchView.findViewById(R.id.search_plate);
        searchPlate.setBackgroundResource(android.R.color.transparent);
    }

    private void setData(View rootView, String[] items, int threshold) {
        View line = rootView.findViewById(R.id.jwt_spinner_dialog_line);
        searchView = rootView.findViewById(R.id.jwt_spinner_dialog_searchview);
        if (items.length > threshold) {
            modifySearchView();
            line.setVisibility(View.VISIBLE);
            searchView.setVisibility(View.VISIBLE);
            searchView.setIconifiedByDefault(false);
            searchView.setOnQueryTextListener(this);
            KeyboardUtils.hideSoftInput(mContext, searchView);
        }

        listView = rootView.findViewById(R.id.jwt_spinner_dialog_listview);
        listAdapter = new JWTAutoCompleteSearchAdapter<>(mContext,
                R.layout.jwt_spinner_v1_dialog_item, items, JWTAutoCompleteSearchAdapter.ALL);
        listView.setAdapter(listAdapter);
        listView.setTextFilterEnabled(true);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                dismiss();
                if (searchItemClickCallBack != null) {
                    searchItemClickCallBack.onSearchItemClick((String) listAdapter.getItem(position));
                }
            }
        });
    }

    public void notifyAll(String[] items) {
        listAdapter.notifyAll(items);
    }

    void setSearchItemClickCallBack(SearchItemClickCallBack<String> searchItemClickCallBack) {
        this.searchItemClickCallBack = searchItemClickCallBack;
    }

    @Override
    public boolean onQueryTextSubmit(String query) {
        searchView.clearFocus();
        return true;
    }

    @Override
    public boolean onQueryTextChange(String newText) {
        if (TextUtils.isEmpty(newText)) {
            ((JWTAutoCompleteSearchAdapter)listView.getAdapter()).getFilter().filter(null);
        } else {
            ((JWTAutoCompleteSearchAdapter)listView.getAdapter()).getFilter().filter(newText);
        }
        return false;
    }

    public interface SearchItemClickCallBack<T> extends Serializable {

        /**
         * item点击事件
         *
         * @param item item
         */
        void onSearchItemClick(T item);
    }
}
