package com.xdja.jwtcomponentslibrary.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;

import com.xdja.jwtcomponentslibrary.R;

import java.util.Locale;

/**
 * Created by ygj on 2018/16/27.
 * 带有标签的进度条(强制更新下载框进度条)
 */

@SuppressLint("AppCompatCustomView")
public class LabelSeekBar extends SeekBar {
    /**
     * 用来表示该组件在整个屏幕内的绝对坐标
     * position[0] 代表X坐标
     * position[1] 代表Y坐标
     */
    private int[] position;
    /**
     * 标签弹出窗口
     */
    private PopupWindow labelPopupWindow;
    /**
     * 显示标签内容的TextView
     */
    private TextView label;
    /**
     * 标签所在弹框布局
     */
    private View labelView;

    public LabelSeekBar(Context context) {
        this(context, null);
    }

    public LabelSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LabelSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        //初始化
        init(context);
    }


    /**
     * 初始化
     *
     * @param context 上下文句柄
     */
    private void init(Context context) {
        //实例化标签弹框
        labelView = LayoutInflater.from(context).inflate(R.layout.jwt_label_seekbar, null);
        label = (TextView) labelView.findViewById(R.id.label_text);
        labelPopupWindow = new PopupWindow(labelView
                , ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        //实例化坐标集
        position = new int[2];
    }

    /**
     * 显示标签
     */
    public void showLabel(View view) {
        if (label == null || labelPopupWindow == null) {
            return;
        }
        int progress = getProgress();
        label.setText(String.format(Locale.getDefault(), "%d%%", progress));
        //获取在整个屏幕内的绝对坐标，注意这个值是要从屏幕顶端算起，也就是包括了通知栏的高度。
        this.getLocationInWindow(position);
        // 计算进度值所占的宽度
        int thumbX = (int) (progress * ((this.getWidth() * 1.00f) / (this.getMax() * 1.00f)));
        int x = thumbX + position[0] - getViewWidth(labelView) / 2;
        // 更新后的PopupWindow的Y坐标
        int y = position[1] - getViewHeight(labelView) - getContext().getResources().getDimensionPixelOffset(R.dimen.padding_4);
        if (labelPopupWindow.isShowing()) {
            //更新popup窗口的位置
            labelPopupWindow.update(x, y, getViewWidth(labelView), getViewHeight(labelView));
        } else {
            // 相对某个控件的位置（正左下方），在X、Y方向各有偏移
            labelPopupWindow.showAtLocation(view, 0, x, y);
        }
    }

    /**
     * 隐藏标签
     */
    public void hideLabel() {
        if (labelPopupWindow == null || !labelPopupWindow.isShowing()) {
            return;
        }
        labelPopupWindow.dismiss();
    }

    /**
     * 获取控件的宽度
     *
     * @param v 要获取宽度的空间
     * @return 控件的宽度
     */
    private int getViewWidth(View v) {
        int w = MeasureSpec.makeMeasureSpec(0, MeasureSpec.UNSPECIFIED);
        int h = MeasureSpec.makeMeasureSpec(0, MeasureSpec.UNSPECIFIED);
        v.measure(w, h);
        return v.getMeasuredWidth();
    }

    /**
     * 获取控件的高度
     *
     * @param v 要获取高度的控件
     * @return 控件的高度
     */
    private int getViewHeight(View v) {
        int w = MeasureSpec.makeMeasureSpec(0, MeasureSpec.UNSPECIFIED);
        int h = MeasureSpec.makeMeasureSpec(0, MeasureSpec.UNSPECIFIED);
        v.measure(w, h);
        return v.getMeasuredHeight();
    }
}
