/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.JWTAutoComplete;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JWTAutoCompleteSearchAdapter<T>
extends BaseAdapter
implements Filterable {
    private List<T> mObjects;
    private final Object mLock = new Object();
    private int mResource;
    private int mFieldId = 0;
    private ArrayList<T> mOriginalValues;
    private ArrayFilter mFilter;
    private LayoutInflater mInflater;
    public static final int ALL = -1;
    private int maxMatch = 10;

    public JWTAutoCompleteSearchAdapter(Context context, int textViewResourceId, T[] objects, int maxMatch) {
        this.init(context, textViewResourceId, 0, Arrays.asList(objects));
        this.maxMatch = maxMatch;
    }

    public JWTAutoCompleteSearchAdapter(Context context, int textViewResourceId, List<T> objects, int maxMatch) {
        this.init(context, textViewResourceId, 0, objects);
        this.maxMatch = maxMatch;
    }

    private void init(Context context, int resource, int textViewResourceId, List<T> objects) {
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mResource = resource;
        this.mObjects = objects;
        this.mFieldId = textViewResourceId;
    }

    public int getCount() {
        return this.mObjects == null ? 0 : this.mObjects.size();
    }

    public T getItem(int position) {
        return this.mObjects == null ? null : (T)this.mObjects.get(position);
    }

    public int getPosition(T item) {
        return this.mObjects == null ? -1 : this.mObjects.indexOf(item);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createViewFromResource(position, convertView, parent, this.mResource);
    }

    private View createViewFromResource(int position, View convertView, ViewGroup parent, int resource) {
        TextView text;
        View view = convertView == null ? this.mInflater.inflate(resource, parent, false) : convertView;
        try {
            text = this.mFieldId == 0 ? (TextView)view : (TextView)view.findViewById(this.mFieldId);
        }
        catch (ClassCastException e) {
            Log.e((String)"ArrayAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("ArrayAdapter requires the resource ID to be a TextView", e);
        }
        text.setText((CharSequence)this.getItem(position).toString());
        return view;
    }

    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    public void notifyAll(T[] objects) {
        this.notifyAll(Arrays.asList(objects));
    }

    public void notifyAll(List<T> objects) {
        this.mObjects = objects;
        this.mOriginalValues = null;
        this.notifyDataSetChanged();
    }

    public <T> Set<T> List2Set(List<T> tList) {
        HashSet<T> tSet = new HashSet<T>(tList);
        return tSet;
    }

    public <T> List<T> Set2List(Set<T> oSet) {
        ArrayList<T> tList = new ArrayList<T>(oSet);
        return tList;
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Object object;
            Filter.FilterResults results = new Filter.FilterResults();
            if (JWTAutoCompleteSearchAdapter.this.mOriginalValues == null) {
                object = JWTAutoCompleteSearchAdapter.this.mLock;
                synchronized (object) {
                    JWTAutoCompleteSearchAdapter.this.mOriginalValues = new ArrayList(JWTAutoCompleteSearchAdapter.this.mObjects);
                }
            }
            if (prefix == null || prefix.length() == 0) {
                object = JWTAutoCompleteSearchAdapter.this.mLock;
                synchronized (object) {
                    ArrayList list;
                    results.values = list = new ArrayList(JWTAutoCompleteSearchAdapter.this.mOriginalValues);
                    results.count = list.size();
                }
            } else {
                List list;
                String prefixString = prefix.toString().toLowerCase();
                ArrayList hanzi = JWTAutoCompleteSearchAdapter.this.mOriginalValues;
                int count = hanzi.size();
                HashSet newValues = new HashSet(count);
                for (int i = 0; i < count; ++i) {
                    Object value = hanzi.get(i);
                    String valueText = value.toString().toLowerCase();
                    if (valueText.contains(prefixString)) {
                        newValues.add(value);
                    }
                    if (JWTAutoCompleteSearchAdapter.this.maxMatch > 0 && newValues.size() > JWTAutoCompleteSearchAdapter.this.maxMatch - 1) break;
                }
                results.values = list = JWTAutoCompleteSearchAdapter.this.Set2List(newValues);
                results.count = list.size();
            }
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            JWTAutoCompleteSearchAdapter.this.mObjects = (List)results.values;
            if (results.count > 0) {
                JWTAutoCompleteSearchAdapter.this.notifyDataSetChanged();
            } else {
                JWTAutoCompleteSearchAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

