/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.StringRes;
import android.widget.Toast;

public class ToastUtils {
    private static Toast sToast;
    private static Handler sHandler;
    private static boolean isJumpWhenMore;

    private ToastUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(boolean isJumpWhenMore) {
        ToastUtils.isJumpWhenMore = isJumpWhenMore;
    }

    public static void showShortToastSafe(final Context context, final CharSequence text) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, text, 0);
            }
        });
    }

    public static void showShortToastSafe(final Context context, final @StringRes int resId) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, resId, 0);
            }
        });
    }

    public static void showShortToastSafe(final Context context, final @StringRes int resId, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, resId, 0, args);
            }
        });
    }

    public static void showShortToastSafe(final Context context, final String format, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, format, 0, args);
            }
        });
    }

    public static void showLongToastSafe(final Context context, final CharSequence text) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, text, 1);
            }
        });
    }

    public static void showLongToastSafe(final Context context, final @StringRes int resId) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, resId, 1);
            }
        });
    }

    public static void showLongToastSafe(final Context context, final @StringRes int resId, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, resId, 1, args);
            }
        });
    }

    public static void showLongToastSafe(final Context context, final String format, final Object ... args) {
        sHandler.post(new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast(context, format, 1, args);
            }
        });
    }

    public static void showShortToast(Context context, CharSequence text) {
        ToastUtils.showToast(context, text, 0);
    }

    public static void showShortToast(Context context, @StringRes int resId) {
        ToastUtils.showToast(context, resId, 0);
    }

    public static void showShortToast(Context context, @StringRes int resId, Object ... args) {
        ToastUtils.showToast(context, resId, 0, args);
    }

    public static void showShortToast(Context context, String format, Object ... args) {
        ToastUtils.showToast(context, format, 0, args);
    }

    public static void showLongToast(Context context, CharSequence text) {
        ToastUtils.showToast(context, text, 1);
    }

    public static void showLongToast(Context context, @StringRes int resId) {
        ToastUtils.showToast(context, resId, 1);
    }

    public static void showLongToast(Context context, @StringRes int resId, Object ... args) {
        ToastUtils.showToast(context, resId, 1, args);
    }

    public static void showLongToast(Context context, String format, Object ... args) {
        ToastUtils.showToast(context, format, 1, args);
    }

    private static void showToast(Context context, @StringRes int resId, int duration) {
        ToastUtils.showToast(context, context.getResources().getText(resId).toString(), duration);
    }

    private static void showToast(Context context, @StringRes int resId, int duration, Object ... args) {
        ToastUtils.showToast(context, String.format(context.getResources().getString(resId), args), duration);
    }

    private static void showToast(Context context, String format, int duration, Object ... args) {
        ToastUtils.showToast(context, String.format(format, args), duration);
    }

    private static void showToast(Context context, CharSequence text, int duration) {
        if (isJumpWhenMore) {
            ToastUtils.cancelToast();
        }
        if (sToast == null) {
            sToast = Toast.makeText((Context)context, (CharSequence)text, (int)duration);
        } else {
            sToast.setText(text);
            sToast.setDuration(duration);
        }
        sToast.show();
    }

    public static void cancelToast() {
        if (sToast != null) {
            sToast.cancel();
            sToast = null;
        }
    }

    static {
        sHandler = new Handler(Looper.getMainLooper());
    }
}

