package com.xdja.jwtcomponentslibrary.edittext;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.View;

import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.utils.KeyboardUtils;

/**
 * Created by wanjing on 2017/8/29.
 * <p>
 * desc: 警务通编辑框。
 */

public class JWTEditText extends AppCompatEditText implements View.OnClickListener, JWTEditTextCallBack {

    private Context mContext;

    private int mInputType;
    private int mThreshold;
    private int mSort;
    private @DimenRes
    int mPaddingResId = R.dimen.padding_8;
    private @DrawableRes
    int mBgResId = R.drawable.jwt_edittext_bg_selector;

    public JWTEditText(Context context) {
        super(context);

        this.mContext = context;
        init();
    }

    public JWTEditText(Context context, AttributeSet attrs) {
        super(context, attrs);

        this.mContext = context;
        initParams(attrs);
        init();
    }

    public JWTEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        this.mContext = context;
        initParams(attrs);
        init();
    }

    private void initParams(AttributeSet attrs) {
        TypedArray typedArray = mContext.obtainStyledAttributes(attrs, R.styleable.JWTEditText);
        if (typedArray != null) {
            mInputType = typedArray.getInt(R.styleable.JWTEditText_inputType, 0);
            mThreshold = typedArray.getInt(R.styleable.JWTEditText_threshold, 2);
            mSort = typedArray.getInt(R.styleable.JWTEditText_sort, -1);
            mPaddingResId = typedArray.getResourceId(R.styleable.JWTEditText_et_padding, R.dimen.padding_8);
            mBgResId = typedArray.getResourceId(R.styleable.JWTEditText_et_background, R.drawable.jwt_edittext_bg_selector);
            typedArray.recycle();
        }
    }

    private void init() {
        setFocusable(false);

        Resources resources = mContext.getResources();
        int padding = resources.getDimensionPixelOffset(mPaddingResId);
        setPadding(padding, padding, padding, padding);
        setMinHeight(resources.getDimensionPixelOffset(R.dimen.min_height));
//        setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        setBackgroundResource(mBgResId);

        setOnClickListener(this);
    }

    @Override
    public void onClick(View view) {
        //关闭系统输入法
        KeyboardUtils.hideSoftInput(mContext, this);

        JWTEditTextInputSoft soft = new JWTEditTextInputSoft(mContext);
        String textStr = "";
        if (getText() != null) {
            textStr = getMyText();
        }
        String hintStr = "";
        if (getHint() != null) {
            hintStr = getHint().toString();
        }
        soft.setCallBack(this);
        soft.setSort(mSort);
        soft.setThreshold(mThreshold);
        soft.showInputSoft(mInputType, textStr, hintStr);
    }

    public String getMyText() {
        return getText().toString();
    }

    @Override
    public void onConfirm(String str) {
        setText(str);
    }
}
