package com.xdja.jwtcomponentslibrary.edittext;

import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;

import com.xdja.jwtcomponentslibrary.R;

import java.util.List;

/**
 * Created by wanjing on 2017/8/29.
 * <p>
 * desc: 警务通输入法按键。
 */

public class JWTEditTextDataAdapter extends RecyclerView.Adapter<JWTEditTextDataAdapter.ViewHolder> {

    private Context mContext;
    private List<String> mData;

    private int height;

    private AdapterView.OnItemClickListener onItemClickListener;

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public JWTEditTextDataAdapter(Context context, List<String> data, int numRows) {
        this.mContext = context;
        this.mData = data;

        this.height = calculateHeight(context, numRows);
    }

    private int calculateHeight(Context context, int numRows) {
        float scale = context.getResources().getDisplayMetrics().density;
        float parentHeight = 248 * scale + 0.5f;
        float padding = 4 * scale + 0.5f;
        return (int) (parentHeight / numRows - padding);
    }

    @Override
    public int getItemCount() {
        return mData == null ? 0 : mData.size();
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Button button = new Button(mContext);
        button.setTextColor(ContextCompat.getColor(mContext, R.color.jwt_input_soft_keys_text_color));
        button.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);
        button.setAllCaps(false);
        button.setFocusable(false);
        button.setClickable(false);
        button.setStateListAnimator(null);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
        layoutParams.setMargins(6, 6, 6, 6);
        button.setLayoutParams(layoutParams);
        return new ViewHolder(button);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        String text = mData.get(position);
        if ("删除".equals(text)) {
            if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP
                    || height < 160) {
                holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys_del);
            } else {
                //适配5.0系统手机
                holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys_del1);
            }
            holder.button.setText("");
        } else if ("复制".equals(text)) {
            holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys_gray);
            holder.button.setText(text);
        } else {
            holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys);
            holder.button.setText(text);
        }
    }

    class ViewHolder extends RecyclerView.ViewHolder {

        Button button;

        public ViewHolder(View itemView) {
            super(itemView);

            button = (Button) itemView;
            button.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (onItemClickListener != null) {
                        // 目前只用得到getAdapterPosition()
                        onItemClickListener.onItemClick(null, button, getAdapterPosition(), getItemId());
                    }
                }
            });
        }
    }
}
