/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.edittext;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.View;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.edittext.JWTEditTextCallBack;
import com.xdja.jwtcomponentslibrary.edittext.JWTEditTextInputSoft;
import com.xdja.jwtcomponentslibrary.utils.KeyboardUtils;

public class JWTEditText
extends AppCompatEditText
implements View.OnClickListener,
JWTEditTextCallBack {
    private Context mContext;
    private int mInputType;
    private int mThreshold;
    private int mSort;
    @DimenRes
    private int mPaddingResId = R.dimen.padding_8;
    @DrawableRes
    private int mBgResId = R.drawable.jwt_edittext_bg_selector;

    public JWTEditText(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public JWTEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initParams(attrs);
        this.init();
    }

    public JWTEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initParams(attrs);
        this.init();
    }

    private void initParams(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.JWTEditText);
        if (typedArray != null) {
            this.mInputType = typedArray.getInt(R.styleable.JWTEditText_inputType, 0);
            this.mThreshold = typedArray.getInt(R.styleable.JWTEditText_threshold, 2);
            this.mSort = typedArray.getInt(R.styleable.JWTEditText_sort, -1);
            this.mPaddingResId = typedArray.getResourceId(R.styleable.JWTEditText_et_padding, R.dimen.padding_8);
            this.mBgResId = typedArray.getResourceId(R.styleable.JWTEditText_et_background, R.drawable.jwt_edittext_bg_selector);
            typedArray.recycle();
        }
    }

    private void init() {
        this.setFocusable(false);
        Resources resources = this.mContext.getResources();
        int padding = resources.getDimensionPixelOffset(this.mPaddingResId);
        this.setPadding(padding, padding, padding, padding);
        this.setMinHeight(resources.getDimensionPixelOffset(R.dimen.min_height));
        this.setBackgroundResource(this.mBgResId);
        this.setOnClickListener(this);
    }

    public void onClick(View view) {
        KeyboardUtils.hideSoftInput(this.mContext, (View)this);
        JWTEditTextInputSoft soft = new JWTEditTextInputSoft(this.mContext);
        String textStr = "";
        if (this.getText() != null) {
            textStr = this.getMyText();
        }
        String hintStr = "";
        if (this.getHint() != null) {
            hintStr = this.getHint().toString();
        }
        soft.setCallBack(this);
        soft.setSort(this.mSort);
        soft.setThreshold(this.mThreshold);
        soft.showInputSoft(this.mInputType, textStr, hintStr);
    }

    public String getMyText() {
        return this.getText().toString();
    }

    @Override
    public void onConfirm(String str) {
        this.setText(str);
    }
}

