/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.edittext;

import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import com.xdja.jwtcomponentslibrary.R;
import java.util.List;

public class JWTEditTextDataAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context mContext;
    private List<String> mData;
    private int height;
    private AdapterView.OnItemClickListener onItemClickListener;

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public JWTEditTextDataAdapter(Context context, List<String> data, int numRows) {
        this.mContext = context;
        this.mData = data;
        this.height = this.calculateHeight(context, numRows);
    }

    private int calculateHeight(Context context, int numRows) {
        float scale = context.getResources().getDisplayMetrics().density;
        float parentHeight = 248.0f * scale + 0.5f;
        float padding = 4.0f * scale + 0.5f;
        return (int)(parentHeight / (float)numRows - padding);
    }

    public int getItemCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Button button = new Button(this.mContext);
        button.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.jwt_input_soft_keys_text_color));
        button.setTextSize(1, 16.0f);
        button.setAllCaps(false);
        button.setFocusable(false);
        button.setClickable(false);
        button.setStateListAnimator(null);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, this.height);
        layoutParams.setMargins(6, 6, 6, 6);
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return new ViewHolder((View)button);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        String text = this.mData.get(position);
        if ("\u5220\u9664".equals(text)) {
            if (Build.VERSION.SDK_INT > 21 || this.height < 160) {
                holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys_del);
            } else {
                holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys_del1);
            }
            holder.button.setText((CharSequence)"");
        } else if ("\u590d\u5236".equals(text)) {
            holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys_gray);
            holder.button.setText((CharSequence)text);
        } else {
            holder.button.setBackgroundResource(R.drawable.jwt_btn_bg_keys);
            holder.button.setText((CharSequence)text);
        }
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        Button button;

        public ViewHolder(View itemView) {
            super(itemView);
            this.button = (Button)itemView;
            this.button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (JWTEditTextDataAdapter.this.onItemClickListener != null) {
                        JWTEditTextDataAdapter.this.onItemClickListener.onItemClick(null, (View)ViewHolder.this.button, ViewHolder.this.getAdapterPosition(), ViewHolder.this.getItemId());
                    }
                }
            });
        }
    }
}

