/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.spinner;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatSpinner;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.spinner.JWTSpinnerCallBack;
import com.xdja.jwtcomponentslibrary.spinner.JWTSpinnerDataItemBean;
import com.xdja.jwtcomponentslibrary.spinner.JWTSpinnerV1DialogView;
import java.util.ArrayList;
import java.util.List;

public class JWTSpinnerV1
extends AppCompatSpinner
implements AdapterView.OnItemSelectedListener {
    private Context mContext;
    private List<JWTSpinnerDataItemBean> mDataItemBeen = new ArrayList<JWTSpinnerDataItemBean>();
    private String[] mDatas;
    private JWTSpinnerCallBack mCallBack;
    private String defaultTextOrValue;
    private int threshold;
    @ColorInt
    private int textColor;
    private float textSize;
    private int textAlignment;
    private int paddingLeft;
    private int paddingRight;
    private int dialogWidth;
    private int dialogHeight;
    private int dialogMaxHeight;
    private boolean dialog;
    private boolean adjustResize;
    private boolean hint;
    private JWTSpinnerV1DialogView alertDialog;

    public JWTSpinnerV1(Context context) {
        this(context, null);
    }

    public JWTSpinnerV1(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public JWTSpinnerV1(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        TypedArray ta = this.mContext.obtainStyledAttributes(attrs, R.styleable.JWTSpinnerV1);
        if (ta != null) {
            this.defaultTextOrValue = ta.getString(R.styleable.JWTSpinnerV1_default_text_value);
            this.threshold = ta.getInteger(R.styleable.JWTSpinnerV1_search_threshold, 5);
            this.textColor = ta.getColor(R.styleable.JWTSpinnerV1_spinner_textColor, ContextCompat.getColor((Context)context, (int)R.color.spinnerV1_default_text_color));
            this.textSize = ta.getDimensionPixelSize(R.styleable.JWTSpinnerV1_spinner_textSize, this.getResources().getDimensionPixelSize(R.dimen.spinnerV1_default_text_size));
            this.textAlignment = ta.getInteger(R.styleable.JWTSpinnerV1_spinner_textAlignment, 5);
            this.paddingLeft = ta.getDimensionPixelSize(R.styleable.JWTSpinnerV1_spinner_paddingLeft, 0);
            this.paddingRight = ta.getDimensionPixelSize(R.styleable.JWTSpinnerV1_spinner_paddingRight, 0);
            this.dialogWidth = ta.getLayoutDimension(R.styleable.JWTSpinnerV1_spinner_dialog_width, this.dp2px(300));
            this.dialogHeight = ta.getLayoutDimension(R.styleable.JWTSpinnerV1_spinner_dialog_height, -2);
            this.dialogMaxHeight = ta.getLayoutDimension(R.styleable.JWTSpinnerV1_spinner_dialog_height_max, this.dp2px(224));
            this.dialog = ta.getBoolean(R.styleable.JWTSpinnerV1_spinner_dialog, true);
            this.adjustResize = ta.getBoolean(R.styleable.JWTSpinnerV1_adjust_resize, false);
            this.hint = ta.getBoolean(R.styleable.JWTSpinnerV1_spinner_hint, false);
            ta.recycle();
        }
        this.setOnItemSelectedListener(this);
    }

    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen) {
        this.setData(dataItemBeen, this.defaultTextOrValue);
    }

    public void setData(List<JWTSpinnerDataItemBean> dataItemBeen, String defaultTextOrValue) {
        if (dataItemBeen == null || dataItemBeen.size() == 0) {
            return;
        }
        this.mDataItemBeen = dataItemBeen;
        this.mDatas = new String[dataItemBeen.size()];
        for (int i = 0; i < this.mDataItemBeen.size(); ++i) {
            this.mDatas[i] = dataItemBeen.get(i).getText();
        }
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(this.mContext, R.layout.jwt_spinner_v1_simple_list_item_1, this.mDatas){

            @NonNull
            public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                TextView textView = (TextView)view;
                textView.setTextColor(JWTSpinnerV1.this.textColor);
                textView.setTextSize(0, JWTSpinnerV1.this.textSize);
                textView.setTextAlignment(JWTSpinnerV1.this.textAlignment);
                textView.setPadding(JWTSpinnerV1.this.paddingLeft, 0, JWTSpinnerV1.this.paddingRight, 0);
                return view;
            }

            public int getCount() {
                if (JWTSpinnerV1.this.hint) {
                    return super.getCount() - 1;
                }
                return super.getCount();
            }
        };
        arrayAdapter.setDropDownViewResource(17367043);
        this.setAdapter((SpinnerAdapter)arrayAdapter);
        if (this.hint) {
            this.setSelection(arrayAdapter.getCount());
            return;
        }
        this.setDefaultValue(defaultTextOrValue);
    }

    public void setDefaultValue(@NonNull String defaultTextOrValue) {
        int selectedPosition = -1;
        if (!TextUtils.isEmpty((CharSequence)defaultTextOrValue)) {
            for (JWTSpinnerDataItemBean dataItemBean : this.mDataItemBeen) {
                if (!defaultTextOrValue.equals(dataItemBean.getText()) && !defaultTextOrValue.equals(dataItemBean.getValue())) continue;
                selectedPosition = this.mDataItemBeen.indexOf(dataItemBean);
                break;
            }
        }
        this.setSelection(selectedPosition, true);
    }

    public void setCallBack(JWTSpinnerCallBack callBack) {
        this.mCallBack = callBack;
    }

    public String getSelectedText() {
        if (this.mDataItemBeen != null && this.mDataItemBeen.size() > this.getSelectedItemPosition()) {
            return this.mDataItemBeen.get(this.getSelectedItemPosition()).getText();
        }
        return "";
    }

    public String getSelectedValue() {
        if (this.mDataItemBeen != null && this.mDataItemBeen.size() > this.getSelectedItemPosition()) {
            return this.mDataItemBeen.get(this.getSelectedItemPosition()).getValue();
        }
        return "";
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mDataItemBeen == null || this.mDataItemBeen.size() <= position) {
            return;
        }
        if (this.mCallBack != null) {
            this.mCallBack.onItemSelected(this.getSelectedText(), this.getSelectedValue());
        }
    }

    public void onNothingSelected(AdapterView<?> parent) {
        if (this.mCallBack != null) {
            this.mCallBack.onNothingSelected();
        }
    }

    public boolean performClick() {
        if (this.mDataItemBeen != null && !this.mDataItemBeen.isEmpty() && (this.dialog || this.mDataItemBeen.size() > this.threshold)) {
            this.showDialogView();
            return true;
        }
        return super.performClick();
    }

    private void showDialogView() {
        Window window;
        if (this.alertDialog == null) {
            this.alertDialog = new JWTSpinnerV1DialogView(this.mContext, this.mDatas, this.threshold, this.hint);
            this.alertDialog.setSearchItemClickCallBack(new JWTSpinnerV1DialogView.SearchItemClickCallBack<String>(){

                @Override
                public void onSearchItemClick(String item) {
                    for (int i = 0; i < JWTSpinnerV1.this.mDatas.length; ++i) {
                        if (!item.equals(JWTSpinnerV1.this.mDatas[i])) continue;
                        JWTSpinnerV1.this.setSelection(i, true);
                        break;
                    }
                }
            });
        }
        this.alertDialog.notifyAll(this.mDatas);
        this.alertDialog.show();
        if (!this.adjustResize && (window = this.alertDialog.getWindow()) != null) {
            int itemHeight;
            int width = this.dialogWidth;
            int height = this.dialogHeight > 0 ? this.dialogHeight : (this.mDatas.length * (itemHeight = this.dp2px(48)) > this.dialogMaxHeight ? this.dialogMaxHeight : this.dialogHeight);
            window.setLayout(width, height);
        }
    }

    private int dp2px(int dp) {
        return (int)(this.mContext.getResources().getDisplayMetrics().density * (float)dp + 0.5f);
    }
}

