package com.xdja.jwtcomponentslibrary.spinner;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.autocomplete.JWTAutoCompleteSearchAdapter;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;

/**
 * @author wanjing
 * @date 2018/3/1
 */
public class JWTSpinnerV1DialogView<E> extends AlertDialog implements SearchView.OnQueryTextListener {

    private Context mContext;

    private SearchView searchView;
    private ListView listView;
    private JWTAutoCompleteSearchAdapter<E> listAdapter;

    private OnItemSelectedListener<E> onItemSelectedListener;

    public JWTSpinnerV1DialogView(Context context, List<E> items, int threshold, boolean hint) {
        super(context);

        init(context, items, threshold, hint);
    }

    private void init(Context context, List<E> items, int threshold, boolean hint) {
        this.mContext = context;

        View rootView = LayoutInflater.from(mContext)
                .inflate(R.layout.jwt_spinner_v1_dialog_view, null);
        setData(rootView, items, threshold, hint);
        setCursorIcon();
        setListener();
        setView(rootView);

        Window window = getWindow();
        if (window != null) {
            window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
        }
    }

    private void setListener() {
        setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                searchView.setQuery("", false);
            }
        });
    }

    private void setCursorIcon() {
        try {
            Class cls = Class.forName("android.support.v7.widget.SearchView");
            Field field = cls.getDeclaredField("mSearchSrcTextView");
            field.setAccessible(true);

            TextView tv = (TextView) field.get(searchView);
            Class[] classes = cls.getDeclaredClasses();
            for (Class cls_ : classes) {
                if (cls_.toString().endsWith("android.support.v7.widget.SearchView$SearchAutoComplete")) {
                    Class targetCls = cls_.getSuperclass().getSuperclass().getSuperclass().getSuperclass();
                    Field cursorIconField = targetCls.getDeclaredField("mCursorDrawableRes");
                    cursorIconField.setAccessible(true);
                    cursorIconField.set(tv, R.drawable.jwt_edittext_cursor);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 按照ui标准修改搜索视图
     */
    private void modifySearchView() {
        //调整搜索图标宽度
        ImageView magImage = searchView.findViewById(R.id.search_mag_icon);
        ViewGroup.LayoutParams magImageLayoutParams = magImage.getLayoutParams();
        magImageLayoutParams.width = ViewGroup.LayoutParams.WRAP_CONTENT;
        magImage.setLayoutParams(magImageLayoutParams);
        //隐藏下划线
        View searchPlate = searchView.findViewById(R.id.search_plate);
        searchPlate.setBackgroundResource(android.R.color.transparent);
    }

    private void setData(View rootView, final List<E> items, int threshold, boolean hint) {
        searchView = rootView.findViewById(R.id.jwt_spinner_dialog_searchview);
        if (items.size() > threshold) {
            searchView.setVisibility(View.VISIBLE);
            searchView.setOnQueryTextListener(this);

            modifySearchView();

            View line = rootView.findViewById(R.id.jwt_spinner_dialog_line);
            line.setVisibility(View.VISIBLE);
        }

        listView = rootView.findViewById(R.id.jwt_spinner_dialog_listview);
        listAdapter = new JWTAutoCompleteSearchAdapter<>(mContext,
                R.layout.jwt_spinner_v1_dialog_item, items, JWTAutoCompleteSearchAdapter.ALL);
        listAdapter.setHint(hint);
        listView.setAdapter(listAdapter);
        listView.setTextFilterEnabled(true);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                dismiss();
                if (onItemSelectedListener != null) {
                    onItemSelectedListener.onItemSelected(listAdapter.getItem(position), items.indexOf(listAdapter.getItem(position)));
                }
            }
        });
    }

    public void notifyAll(List<E> items) {
        listAdapter.notifyAll(items);
    }

   public void setSearchItemClickCallBack(OnItemSelectedListener<E> onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    @Override
    public boolean onQueryTextSubmit(String query) {
        searchView.clearFocus();
        return true;
    }

    @Override
    public boolean onQueryTextChange(String newText) {
        if (TextUtils.isEmpty(newText)) {
            ((JWTAutoCompleteSearchAdapter) listView.getAdapter()).getFilter().filter(null);
        } else {
            ((JWTAutoCompleteSearchAdapter) listView.getAdapter()).getFilter().filter(newText);
        }
        return false;
    }

    public interface OnItemSelectedListener<T> extends Serializable {

        /**
         * item点击事件
         *
         * @param item item
         */
        void onItemSelected(T item, int position);
    }
}
