package com.xdja.jwtcomponentslibrary.dialog;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDialog;
import android.view.KeyEvent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.xdja.jwtcomponentslibrary.R;

/**
 * @author wanjing
 * @date 2018/8/14
 * <p>
 * 自定义加载进度框
 */
public class JWTProgressDialog extends AppCompatDialog {

    private String content;

    public JWTProgressDialog(Context context) {
        this(context, "加载中...");
    }

    public JWTProgressDialog(Context context, String content) {
        super(context, R.style.JWTProgressDialog);
        this.content = content;
        initView();
    }

    private void initView() {
        setContentView(R.layout.jwt_pdialog);
        TextView textView = (TextView) findViewById(R.id.jwt_pdialog_tv_content);
        if (textView != null) {
            textView.setText(content);
        }
        Window window = getWindow();
        if (window != null) {
            WindowManager.LayoutParams attributes = window.getAttributes();
            attributes.alpha = 0.8f;
            window.setAttributes(attributes);
        }
        setCanceledOnTouchOutside(true);
        setCancelable(false);
    }

    @Override
    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (isShowing()) {
                dismiss();
            }
        }
        return true;
    }
}
