/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.app.AlertDialog;
import com.xdja.jwtcomponentslibrary.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MDialog {
    private boolean mCancel;
    private boolean mCancelable = true;
    private Context mContext;
    private AlertDialog mAlertDialog;
    private Builder mBuilder;
    private int mTitleResId;
    private CharSequence mTitle;
    private int mMessageResId;
    private CharSequence mMessage;
    private TextView mPositiveButton;
    private boolean positiveButtonExit;
    private TextView mNegativeButton;
    private boolean negativeButtonExit;
    private TextView mNeutralButton;
    private boolean neutralButtonIsShow;
    private LinearLayout mainView;
    private View mDialogView;
    private int messageGravity = 17;
    private int messageTextAlignment = 2;
    private int gravity = 17;
    private boolean mHasShow = false;
    private int width;
    private int height;
    @DrawableRes
    private int bgResId;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private DialogInterface.OnKeyListener onKeyListener;
    private String mPositiveButtonTitle;
    private View.OnClickListener mPositiveButtonClick;
    private String mNegativeButtonTitle;
    private View.OnClickListener mNegativeButtonClick;
    private String mNeutralButtonTitle;
    private View.OnClickListener mNeutralButtonClick;
    private DialogInterface.OnShowListener onShowListener;

    public void setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        this.onKeyListener = onKeyListener;
    }

    public MDialog(Context context) {
        this.mContext = context;
        this.width = (int)(this.mContext.getResources().getDisplayMetrics().density * 270.0f + 0.5f);
        this.height = -2;
        this.bgResId = R.drawable.jwt_dialog_bg_shape;
    }

    public void setOnShowListener(DialogInterface.OnShowListener onShowListener) {
        this.onShowListener = onShowListener;
    }

    public boolean isShowing() {
        return this.mAlertDialog != null && this.mAlertDialog.isShowing();
    }

    public void show() {
        if (this.mHasShow) {
            this.mAlertDialog.show();
        } else {
            this.mBuilder = new Builder();
        }
        this.mHasShow = true;
    }

    public MDialog setView(View view) {
        this.mDialogView = view;
        if (this.mBuilder != null) {
            this.mBuilder.setView(view);
        }
        return this;
    }

    public void dismiss() {
        this.mAlertDialog.dismiss();
    }

    public MDialog setTitle(int resId) {
        this.mTitleResId = resId;
        if (this.mBuilder != null) {
            this.mBuilder.setTitle(resId);
        }
        return this;
    }

    public MDialog setTitle(CharSequence title) {
        this.mTitle = title;
        if (this.mBuilder != null) {
            this.mBuilder.setTitle(title);
        }
        return this;
    }

    public MDialog setMessage(int resId) {
        this.mMessageResId = resId;
        if (this.mBuilder != null) {
            this.mBuilder.setMessage(resId);
        }
        return this;
    }

    public MDialog setMessage(CharSequence message) {
        this.mMessage = message;
        if (this.mBuilder != null) {
            this.mBuilder.setMessage(message);
        }
        return this;
    }

    public MDialog setMessageGravity(int gravity) {
        this.messageGravity = gravity;
        if (this.mBuilder != null) {
            this.mBuilder.setMessageGravity(gravity);
        }
        return this;
    }

    public MDialog setMessageTextAlignment(int textAlignment) {
        this.messageTextAlignment = textAlignment;
        if (this.mBuilder != null) {
            this.mBuilder.setMessageTextAlignment(textAlignment);
        }
        return this;
    }

    public MDialog setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public MDialog setNeutralButton(String text, View.OnClickListener listener) {
        this.neutralButtonIsShow = true;
        this.mNeutralButtonTitle = text;
        this.mNeutralButtonClick = listener;
        if (this.mBuilder != null) {
            this.mBuilder.setNeutralButton(text, listener);
        }
        return this;
    }

    public MDialog setPositiveButton(String text, View.OnClickListener listener) {
        this.positiveButtonExit = true;
        this.mPositiveButtonTitle = text;
        this.mPositiveButtonClick = listener;
        if (this.mBuilder != null) {
            this.mBuilder.setPositiveButton(text, listener);
        }
        return this;
    }

    public MDialog setNegativeButton(String text, View.OnClickListener listener) {
        this.negativeButtonExit = true;
        this.mNegativeButtonTitle = text;
        this.mNegativeButtonClick = listener;
        if (this.mBuilder != null) {
            this.mBuilder.setNegativeButton(text, listener);
        }
        return this;
    }

    public MDialog setCanceledOnTouchOutside(boolean cancel) {
        this.mCancel = cancel;
        if (this.mBuilder != null) {
            this.mBuilder.setCanceledOnTouchOutside(this.mCancel);
        }
        return this;
    }

    public MDialog setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        if (this.mBuilder != null) {
            this.mBuilder.setCancelable(this.mCancelable);
        }
        return this;
    }

    public MDialog setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    public void setLayout(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setBackgroundResource(int bgResId) {
        this.bgResId = bgResId;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextAlignment {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GravityType {
    }

    private class Builder {
        private TextView mTitleView;
        private TextView mMessageView;
        private View contentView;

        private Builder() {
            MDialog.this.mAlertDialog = new AlertDialog.Builder(MDialog.this.mContext, R.style.DialogTransparent).create();
            MDialog.this.mAlertDialog.getWindow().clearFlags(131080);
            MDialog.this.mAlertDialog.getWindow().setSoftInputMode(4);
            this.contentView = LayoutInflater.from((Context)MDialog.this.mContext).inflate(R.layout.jwt_mdialog, null);
            MDialog.this.mAlertDialog.setView(this.contentView);
            LinearLayout parent = (LinearLayout)this.contentView.findViewById(R.id.ll_parent);
            parent.setBackgroundResource(MDialog.this.bgResId);
            this.mTitleView = (TextView)this.contentView.findViewById(R.id.mDialog_title);
            this.mMessageView = (TextView)this.contentView.findViewById(R.id.mDialog_message);
            MDialog.this.mPositiveButton = (TextView)this.contentView.findViewById(R.id.mDialog_positive);
            MDialog.this.mNegativeButton = (TextView)this.contentView.findViewById(R.id.mDialog_negative);
            MDialog.this.mNeutralButton = (TextView)this.contentView.findViewById(R.id.mDialog_neutral);
            LinearLayout buttonLayout = (LinearLayout)this.contentView.findViewById(R.id.mDialog_btn_layout);
            View btnTopLine = this.contentView.findViewById(R.id.mDialog_btn_top_line);
            MDialog.this.mainView = (LinearLayout)this.contentView.findViewById(R.id.mDialog_view);
            View mBtnLine = this.contentView.findViewById(R.id.mDialog_btn_line);
            View mBtnLine2 = this.contentView.findViewById(R.id.mDialog_btn_line_2);
            if (MDialog.this.mTitleResId != 0) {
                this.setTitle(MDialog.this.mTitleResId);
                this.mTitleView.setVisibility(0);
            }
            if (MDialog.this.mTitle != null) {
                this.setTitle(MDialog.this.mTitle);
                this.mTitleView.setVisibility(0);
            }
            if (MDialog.this.mMessageResId != 0) {
                this.setMessage(MDialog.this.mMessageResId);
                this.mMessageView.setVisibility(0);
            }
            if (MDialog.this.mMessage != null) {
                this.setMessage(MDialog.this.mMessage);
                this.mMessageView.setVisibility(0);
            }
            this.setMessageGravity(MDialog.this.messageGravity);
            this.setMessageTextAlignment(MDialog.this.messageTextAlignment);
            if (MDialog.this.positiveButtonExit) {
                this.setPositiveButton(MDialog.this.mPositiveButtonTitle, MDialog.this.mPositiveButtonClick);
                MDialog.this.mPositiveButton.setVisibility(0);
            }
            if (MDialog.this.negativeButtonExit) {
                this.setNegativeButton(MDialog.this.mNegativeButtonTitle, MDialog.this.mNegativeButtonClick);
                MDialog.this.mNegativeButton.setVisibility(0);
            }
            if (MDialog.this.neutralButtonIsShow) {
                this.setNeutralButton(MDialog.this.mNeutralButtonTitle, MDialog.this.mNeutralButtonClick);
                MDialog.this.mNeutralButton.setVisibility(0);
                MDialog.this.mNeutralButton.setBackgroundResource(R.drawable.jwt_mdialog_neutral_btn_bg_selector);
            }
            if (MDialog.this.positiveButtonExit && !MDialog.this.negativeButtonExit) {
                MDialog.this.mPositiveButton.setBackgroundResource(R.drawable.jwt_mdialog_one_btn_bg_selector);
            }
            if (MDialog.this.negativeButtonExit && !MDialog.this.positiveButtonExit) {
                MDialog.this.mNegativeButton.setBackgroundResource(R.drawable.jwt_mdialog_one_btn_bg_selector);
            }
            if (MDialog.this.neutralButtonIsShow && !MDialog.this.positiveButtonExit && !MDialog.this.negativeButtonExit) {
                MDialog.this.mNeutralButton.setBackgroundResource(R.drawable.jwt_mdialog_one_btn_bg_selector);
            }
            if (MDialog.this.negativeButtonExit && MDialog.this.positiveButtonExit) {
                mBtnLine.setVisibility(0);
            }
            if (MDialog.this.negativeButtonExit && MDialog.this.positiveButtonExit && MDialog.this.neutralButtonIsShow) {
                mBtnLine.setVisibility(0);
                mBtnLine2.setVisibility(0);
            }
            if (MDialog.this.negativeButtonExit || MDialog.this.positiveButtonExit || MDialog.this.neutralButtonIsShow) {
                buttonLayout.setVisibility(0);
                btnTopLine.setVisibility(0);
            }
            if (MDialog.this.mDialogView != null) {
                this.setView(MDialog.this.mDialogView);
            }
            MDialog.this.mAlertDialog.setCanceledOnTouchOutside(MDialog.this.mCancel);
            if (MDialog.this.mOnDismissListener != null) {
                MDialog.this.mAlertDialog.setOnDismissListener(MDialog.this.mOnDismissListener);
            }
            if (MDialog.this.onKeyListener != null) {
                MDialog.this.mAlertDialog.setOnKeyListener(MDialog.this.onKeyListener);
            }
            if (MDialog.this.onShowListener != null) {
                MDialog.this.mAlertDialog.setOnShowListener(MDialog.this.onShowListener);
            }
            MDialog.this.mAlertDialog.setCancelable(MDialog.this.mCancelable);
            MDialog.this.mAlertDialog.show();
            Window window = MDialog.this.mAlertDialog.getWindow();
            window.setWindowAnimations(R.style.DialogAnim);
            window.setGravity(MDialog.this.gravity);
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.width = MDialog.this.width;
            layoutParams.height = MDialog.this.height;
            layoutParams.dimAmount = 0.65f;
            int dimensionPixelSize = MDialog.this.mContext.getResources().getDimensionPixelSize(R.dimen.padding_18);
            layoutParams.y += dimensionPixelSize;
            window.setAttributes(layoutParams);
        }

        private void setTitle(int resId) {
            this.mTitleView.setText(resId);
        }

        private void setTitle(CharSequence title) {
            this.mTitleView.setText(title);
        }

        private void setMessage(int resId) {
            this.mMessageView.setText(resId);
        }

        private void setMessage(CharSequence message) {
            this.mMessageView.setText(message);
        }

        private void setMessageGravity(int gravity) {
            this.mMessageView.setGravity(gravity);
        }

        private void setMessageTextAlignment(int textAlignment) {
            this.mMessageView.setTextAlignment(textAlignment);
        }

        private void setPositiveButton(String text, View.OnClickListener listener) {
            MDialog.this.mPositiveButton.setText((CharSequence)text);
            MDialog.this.mPositiveButton.setOnClickListener(listener);
        }

        private void setNegativeButton(String text, View.OnClickListener listener) {
            MDialog.this.mNegativeButton.setText((CharSequence)text);
            MDialog.this.mNegativeButton.setOnClickListener(listener);
        }

        private void setNeutralButton(String text, View.OnClickListener listener) {
            MDialog.this.mNeutralButton.setText((CharSequence)text);
            MDialog.this.mNeutralButton.setOnClickListener(listener);
        }

        private void setView(View view) {
            MDialog.this.mainView.removeAllViews();
            MDialog.this.mainView.addView(view);
        }

        private void setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
            MDialog.this.mAlertDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
        }

        private void setCancelable(boolean cancelable) {
            MDialog.this.mAlertDialog.setCancelable(cancelable);
        }
    }
}

