/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.edittext;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.provider.Settings;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.edittext.JWTEditTextCallBack;
import com.xdja.jwtcomponentslibrary.edittext.JWTEditTextDBUtils;
import com.xdja.jwtcomponentslibrary.edittext.JWTEditTextDataAdapter;
import com.xdja.jwtcomponentslibrary.edittext.JWTEditTextHistoryAdapter;
import com.xdja.jwtcomponentslibrary.utils.IdCardUtils;
import com.xdja.jwtcomponentslibrary.utils.RegexUtils;
import com.xdja.jwtcomponentslibrary.utils.ToastUtils;
import com.xdja.jwtcomponentslibrary.utils.VibrationUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JWTEditTextInputSoft
implements View.OnClickListener,
TextWatcher,
View.OnTouchListener,
ViewPager.OnPageChangeListener {
    private Context mContext;
    private JWTEditTextCallBack mJWTEditTextCallBack;
    private int mThreshold;
    private int mSort;
    private String mDefaultText;
    private final List<String> zmUpperData = new ArrayList<String>();
    private final List<String> zmLowerData = new ArrayList<String>();
    private final List<String> numData = new ArrayList<String>();
    private PopupWindow popupWindow;
    private View popupView;
    private TextView tsclTv;
    private TextView sfTv;
    private TextView zmTv;
    private TextView szTv;
    private RecyclerView listView;
    private JWTEditTextHistoryAdapter historyAdapter;
    private EditText clearEdit;
    private ImageView delIv;
    private ViewPager viewPager;
    private List<View> views = new ArrayList<View>();
    private SparseArray<List<String>> data = new SparseArray();
    private Integer[] spanCountArray;
    private Integer[] numRowsArray;
    private JWTEditTextDBUtils dbUtils;
    private List<String> queryData;
    private final String UPPERCASE = "\u5927\u5199";
    private final String LOWERCASE = "\u5c0f\u5199";
    private final String DELETE = "\u5220\u9664";
    private final String COPY = "\u590d\u5236";
    private boolean plateMode;

    public JWTEditTextInputSoft(Context context, boolean plateMode) {
        this.mContext = context;
        this.plateMode = plateMode;
        this.initData();
        this.initPopupView();
        this.initPopupWindow();
        this.initGridViews();
        this.initPagerAdapter();
    }

    private void initPagerAdapter() {
        PagerAdapter pagerAdapter = new PagerAdapter(){

            public boolean isViewFromObject(View arg0, Object arg1) {
                return arg0 == arg1;
            }

            public int getCount() {
                return JWTEditTextInputSoft.this.views == null ? 0 : JWTEditTextInputSoft.this.views.size();
            }

            public void destroyItem(ViewGroup container, int position, Object view) {
                container.removeView((View)view);
            }

            public Object instantiateItem(ViewGroup collection, int position) {
                View view = (View)JWTEditTextInputSoft.this.views.get(position);
                collection.addView(view, 0);
                return view;
            }
        };
        this.viewPager.setOffscreenPageLimit(1);
        this.viewPager.setAdapter(pagerAdapter);
    }

    private GridLayoutManager getGridLayoutManager(final int index) {
        GridLayoutManager gridLayoutManager = new GridLayoutManager(this.mContext, this.spanCountArray[index].intValue());
        if (index == 2) {
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    String text = (String)((List)JWTEditTextInputSoft.this.data.valueAt(index)).get(position);
                    if (RegexUtils.isMatch("\\d", text)) {
                        return 4;
                    }
                    if (RegexUtils.isMatch("[\u4e00-\u9fa5]{2}", text)) {
                        return 10;
                    }
                    return 5;
                }
            });
        } else if (index == 3) {
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (position > 8) {
                        return 3;
                    }
                    return 4;
                }
            });
        }
        return gridLayoutManager;
    }

    private void initGridViews() {
        for (int index = 0; index < this.data.size(); ++index) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_edittext_gridview, null);
            RecyclerView gridView = (RecyclerView)view.findViewById(R.id.soft_grid_view);
            gridView.setLayoutManager((RecyclerView.LayoutManager)this.getGridLayoutManager(index));
            final List buttons = (List)this.data.valueAt(index);
            final JWTEditTextDataAdapter adapter = new JWTEditTextDataAdapter(this.mContext, buttons, this.numRowsArray[index]);
            adapter.setPlateMode(this.plateMode);
            gridView.setAdapter((RecyclerView.Adapter)adapter);
            adapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    JWTEditTextInputSoft.this.vibrate();
                    String button = (String)buttons.get(position);
                    if ("\u5927\u5199".equals(button)) {
                        buttons.clear();
                        buttons.addAll(JWTEditTextInputSoft.this.numData);
                        buttons.addAll(JWTEditTextInputSoft.this.zmUpperData);
                        adapter.notifyDataSetChanged();
                    } else if ("\u5c0f\u5199".equals(button)) {
                        buttons.clear();
                        buttons.addAll(JWTEditTextInputSoft.this.numData);
                        buttons.addAll(JWTEditTextInputSoft.this.zmLowerData);
                        adapter.notifyDataSetChanged();
                    } else if ("\u590d\u5236".equals(button)) {
                        JWTEditTextInputSoft.this.copyAction();
                    } else if ("\u5220\u9664".equals(button)) {
                        JWTEditTextInputSoft.this.delAction();
                    } else {
                        JWTEditTextInputSoft.this.setResult(button);
                    }
                }
            });
            this.views.add(view);
        }
    }

    private void initPopupView() {
        if (this.popupView == null) {
            this.popupView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_edittext_inputsoft, null);
            Button confirmBtn = (Button)this.popupView.findViewById(R.id.confirm_btn);
            this.tsclTv = (TextView)this.popupView.findViewById(R.id.tscl_btn);
            this.sfTv = (TextView)this.popupView.findViewById(R.id.sf_btn);
            this.zmTv = (TextView)this.popupView.findViewById(R.id.zm_btn);
            this.szTv = (TextView)this.popupView.findViewById(R.id.sz_btn);
            this.delIv = (ImageView)this.popupView.findViewById(R.id.del_iv);
            this.listView = (RecyclerView)this.popupView.findViewById(R.id.history_list);
            this.clearEdit = (EditText)this.popupView.findViewById(R.id.result_edit);
            this.viewPager = (ViewPager)this.popupView.findViewById(R.id.edit_viewpager);
            confirmBtn.setOnClickListener((View.OnClickListener)this);
            this.tsclTv.setOnClickListener((View.OnClickListener)this);
            this.sfTv.setOnClickListener((View.OnClickListener)this);
            this.zmTv.setOnClickListener((View.OnClickListener)this);
            this.szTv.setOnClickListener((View.OnClickListener)this);
            this.delIv.setOnClickListener((View.OnClickListener)this);
            this.clearEdit.setOnTouchListener((View.OnTouchListener)this);
            this.clearEdit.addTextChangedListener((TextWatcher)this);
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.clearEdit.setShowSoftInputOnFocus(false);
        }
    }

    private void initPopupWindow() {
        if (this.popupWindow == null) {
            WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
            DisplayMetrics outMetrics = new DisplayMetrics();
            manager.getDefaultDisplay().getRealMetrics(outMetrics);
            Point point = new Point();
            manager.getDefaultDisplay().getSize(point);
            this.popupWindow = new PopupWindow(this.popupView, -1, outMetrics.heightPixels - this.getNavigationBarHeight(this.mContext));
            this.popupWindow.setFocusable(true);
            this.popupWindow.setOutsideTouchable(true);
            this.popupWindow.setClippingEnabled(false);
            this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1090519040));
            this.popupWindow.setSoftInputMode(16);
        }
    }

    private void initData() {
        String[] tsclDataArray = this.mContext.getResources().getStringArray(R.array.tscl);
        String[] sfDataArray = this.mContext.getResources().getStringArray(R.array.sf);
        String[] zmYDataArray = this.mContext.getResources().getStringArray(R.array.zm_y);
        String[] zmXDataArray = this.mContext.getResources().getStringArray(R.array.zm_x);
        String[] sfzDataArray = this.mContext.getResources().getStringArray(R.array.sfz);
        this.zmUpperData.addAll(Arrays.asList(zmYDataArray));
        this.zmLowerData.addAll(Arrays.asList(zmXDataArray));
        List<String> sfzData = Arrays.asList(sfzDataArray);
        this.numData.addAll(sfzData.subList(0, sfzDataArray.length - 4));
        this.numData.add("0");
        this.data.append(0, Arrays.asList(tsclDataArray));
        this.data.append(1, Arrays.asList(sfDataArray));
        ArrayList<String> zmData = new ArrayList<String>();
        zmData.addAll(this.numData);
        zmData.addAll(this.zmUpperData);
        this.data.append(2, zmData);
        this.data.append(3, sfzData);
        this.spanCountArray = new Integer[]{3, 7, 40, 12};
        this.numRowsArray = new Integer[]{4, 5, 5, 4};
    }

    public void setCallBack(JWTEditTextCallBack callBack) {
        this.mJWTEditTextCallBack = callBack;
    }

    public void setSort(int sort) {
        this.mSort = sort;
    }

    public void setThreshold(int threshold) {
        this.mThreshold = threshold;
    }

    public void showInputSoft(int inputType, String defaultText, String hint) {
        this.mDefaultText = defaultText;
        this.clearEdit.setText((CharSequence)defaultText);
        this.clearEdit.setSelection(defaultText.length());
        this.clearEdit.setHint((CharSequence)hint);
        this.viewPager.setCurrentItem(inputType);
        if (this.popupWindow != null && this.popupView != null) {
            this.popupWindow.showAtLocation(this.popupView.getRootView(), 48, 0, 0);
        }
    }

    public void onClick(View view) {
        this.vibrate();
        int i = view.getId();
        if (i == R.id.del_iv) {
            this.clearAction();
        } else if (i == R.id.confirm_btn) {
            this.confirmAction(this.clearEdit.getText().toString());
        } else if (i == R.id.tscl_btn) {
            this.viewPager.setCurrentItem(0);
        } else if (i == R.id.sf_btn) {
            this.viewPager.setCurrentItem(1);
        } else if (i == R.id.zm_btn) {
            this.viewPager.setCurrentItem(2);
        } else if (i == R.id.sz_btn) {
            this.viewPager.setCurrentItem(3);
        }
    }

    private void dismiss() {
        if (this.dbUtils != null) {
            this.dbUtils.closeDatabase();
            this.dbUtils = null;
        }
        this.popupWindow.dismiss();
    }

    private void confirmAction(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            if (this.mSort == 0 && !RegexUtils.isMatch("(^[\\u4e00-\\u9fa5][A-Z][A-Z0-9]{4}[A-Z0-9\u6e2f\u6fb3\u5b66\u6302\u8bd5\u8d85\u8b66\u9886]$)|(^[\\u4e00-\\u9fa5][A-Z](([DF](?![IO])[A-Z0-9][0-9]{4})|([0-9]{5}[DF]))$)|(^[0-9]{3}[A-Z0-9]{3}[\u4f7f\u9886]$)|(^WJ[\\u4e00-\\u9fa5][A-Z0-9]{4}[0-9XBTSHJD]$)", content)) {
                this.showToast("\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                return;
            }
            if (this.mSort == 1) {
                if (!RegexUtils.isMatch("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)", content)) {
                    this.showToast("\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                    return;
                }
                if (!IdCardUtils.isIdentityCode(content)) {
                    this.showToast("\u8eab\u4efd\u8bc1\u6821\u9a8c\u7801\u65e0\u6548\uff0c\u4e0d\u662f\u5408\u6cd5\u7684\u8eab\u4efd\u8bc1\u53f7\u7801");
                    return;
                }
            }
            if (this.dbUtils == null) {
                this.dbUtils = new JWTEditTextDBUtils(this.mContext);
            }
            this.dbUtils.saveHistory(content);
        }
        if (this.mJWTEditTextCallBack != null) {
            this.mJWTEditTextCallBack.onConfirm(content);
        }
        this.dismiss();
    }

    private void delAction() {
        String text = this.clearEdit.getText().toString();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        int selection = this.clearEdit.getSelectionStart();
        if (selection <= 0) {
            return;
        }
        this.clearEdit.setText((CharSequence)String.format("%s%s", text.substring(0, selection - 1), text.substring(selection)));
        this.clearEdit.setSelection(selection - 1);
    }

    private void copyAction() {
        String text = this.clearEdit.getText().toString();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        ClipboardManager cmb = (ClipboardManager)this.mContext.getSystemService("clipboard");
        if (cmb != null) {
            cmb.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)text));
            this.showToast("\u5df2\u7ecf\u590d\u5236\u5230\u7c98\u8d34\u677f\uff01");
        }
    }

    private void clearAction() {
        this.clearEdit.setText((CharSequence)"");
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
        if (TextUtils.isEmpty((CharSequence)editable.toString())) {
            this.delIv.setVisibility(8);
            this.listView.setVisibility(8);
            return;
        }
        this.delIv.setVisibility(0);
        if (!TextUtils.isEmpty((CharSequence)this.mDefaultText)) {
            this.listView.setVisibility(8);
            this.mDefaultText = "";
            return;
        }
        if (editable.length() > this.mThreshold) {
            List<String> result;
            if (this.dbUtils == null) {
                this.dbUtils = new JWTEditTextDBUtils(this.mContext);
            }
            if ((result = this.dbUtils.query(editable.toString())) == null || result.size() == 0) {
                this.listView.setVisibility(8);
            } else {
                this.queryData = result;
                this.listView.setVisibility(0);
                if (this.historyAdapter == null) {
                    this.listView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 0, false));
                    this.listView.setHasFixedSize(true);
                    this.listView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
                    this.historyAdapter = new JWTEditTextHistoryAdapter(this.queryData, new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                            if (JWTEditTextInputSoft.this.queryData != null && JWTEditTextInputSoft.this.queryData.size() > position) {
                                JWTEditTextInputSoft.this.confirmAction((String)JWTEditTextInputSoft.this.queryData.get(position));
                            }
                        }
                    });
                    this.listView.setAdapter((RecyclerView.Adapter)this.historyAdapter);
                } else {
                    this.historyAdapter.updateData(this.queryData);
                }
            }
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        EditText et = (EditText)view;
        Class<EditText> cls = EditText.class;
        try {
            Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
            setShowSoftInputOnFocus.setAccessible(false);
            setShowSoftInputOnFocus.invoke((Object)et, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        et.onTouchEvent(motionEvent);
        return true;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.tsclTv.setSelected(position == 0);
        this.sfTv.setSelected(position == 1);
        this.zmTv.setSelected(position == 2);
        this.szTv.setSelected(position == 3);
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void showToast(String message) {
        ToastUtils.showShortToast(this.mContext, message);
    }

    private void vibrate() {
        this.vibrate(20L);
    }

    private void vibrate(long milliseconds) {
        VibrationUtils.vibrate(this.mContext, milliseconds);
    }

    private void setResult(String input) {
        int selection = this.clearEdit.getSelectionStart();
        String text = this.clearEdit.getText().toString();
        this.clearEdit.setText((CharSequence)String.format("%s%s%s", text.substring(0, selection), input, text.substring(selection)));
        this.clearEdit.setSelection(selection + input.length());
    }

    private int getStatusBarHeightCompat(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        if (result <= 0) {
            result = context.getResources().getDimensionPixelOffset(R.dimen.dimen_25dp);
        }
        return result;
    }

    private int getNavigationBarHeight(Context context) {
        if (!this.checkNavigationBarShow(context)) {
            return 0;
        }
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    private boolean checkNavigationBarShow(@NonNull Context context) {
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            int navigationBarIsMin = 0;
            navigationBarIsMin = Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0) : Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0);
            if ("1".equals(navBarOverride) || 1 == navigationBarIsMin) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasNavigationBar;
    }
}

