/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jwtcomponentslibrary.spinner;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SearchView;
import com.xdja.jwtcomponentslibrary.R;
import com.xdja.jwtcomponentslibrary.autocomplete.JWTAutoCompleteSearchAdapter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;

public class JWTSpinnerV1DialogView<E>
extends AlertDialog
implements SearchView.OnQueryTextListener {
    private Context mContext;
    private SearchView searchView;
    private ListView listView;
    private JWTAutoCompleteSearchAdapter<E> listAdapter;
    private OnItemSelectedListener<E> onItemSelectedListener;

    public JWTSpinnerV1DialogView(Context context, List<E> items, int threshold, boolean hint) {
        super(context);
        this.init(context, items, threshold, hint);
    }

    private void init(Context context, List<E> items, int threshold, boolean hint) {
        this.mContext = context;
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.jwt_spinner_v1_dialog_view, null);
        this.setData(rootView, items, threshold, hint);
        this.setCursorIcon();
        this.setListener();
        this.setView(rootView);
        Window window = this.getWindow();
        if (window != null) {
            window.setSoftInputMode(2);
        }
    }

    private void setListener() {
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                JWTSpinnerV1DialogView.this.searchView.setQuery((CharSequence)"", false);
            }
        });
    }

    private void setCursorIcon() {
        try {
            Class<?>[] classes;
            Class<?> cls = Class.forName("androidx.appcompat.widget.SearchView");
            Field field = cls.getDeclaredField("mSearchSrcTextView");
            field.setAccessible(true);
            TextView tv = (TextView)field.get(this.searchView);
            for (Class<?> cls_ : classes = cls.getDeclaredClasses()) {
                if (!cls_.toString().endsWith("androidx.appcompat.widget.SearchView$SearchAutoComplete")) continue;
                Class<?> targetCls = cls_.getSuperclass().getSuperclass().getSuperclass().getSuperclass();
                Field cursorIconField = targetCls.getDeclaredField("mCursorDrawableRes");
                cursorIconField.setAccessible(true);
                cursorIconField.set(tv, R.drawable.jwt_edittext_cursor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void modifySearchView() {
        ImageView magImage = (ImageView)this.searchView.findViewById(R.id.search_mag_icon);
        ViewGroup.LayoutParams magImageLayoutParams = magImage.getLayoutParams();
        magImageLayoutParams.width = -2;
        magImage.setLayoutParams(magImageLayoutParams);
        View searchPlate = this.searchView.findViewById(R.id.search_plate);
        searchPlate.setBackgroundResource(17170445);
    }

    private void setData(View rootView, final List<E> items, int threshold, boolean hint) {
        this.searchView = (SearchView)rootView.findViewById(R.id.jwt_spinner_dialog_searchview);
        if (items.size() > threshold) {
            this.searchView.setVisibility(0);
            this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
            this.modifySearchView();
            View line = rootView.findViewById(R.id.jwt_spinner_dialog_line);
            line.setVisibility(0);
        }
        this.listView = (ListView)rootView.findViewById(R.id.jwt_spinner_dialog_listview);
        this.listAdapter = new JWTAutoCompleteSearchAdapter<E>(this.mContext, R.layout.jwt_spinner_v1_dialog_item, items, -1);
        this.listAdapter.setHint(hint);
        this.listView.setAdapter(this.listAdapter);
        this.listView.setTextFilterEnabled(true);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                JWTSpinnerV1DialogView.this.dismiss();
                if (JWTSpinnerV1DialogView.this.onItemSelectedListener != null) {
                    JWTSpinnerV1DialogView.this.onItemSelectedListener.onItemSelected(JWTSpinnerV1DialogView.this.listAdapter.getItem(position), items.indexOf(JWTSpinnerV1DialogView.this.listAdapter.getItem(position)));
                }
            }
        });
    }

    public void notifyAll(List<E> items) {
        this.listAdapter.notifyAll(items);
    }

    public void setSearchItemClickCallBack(OnItemSelectedListener<E> onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public boolean onQueryTextSubmit(String query) {
        this.searchView.clearFocus();
        return true;
    }

    public boolean onQueryTextChange(String newText) {
        if (TextUtils.isEmpty((CharSequence)newText)) {
            ((JWTAutoCompleteSearchAdapter)this.listView.getAdapter()).getFilter().filter(null);
        } else {
            ((JWTAutoCompleteSearchAdapter)this.listView.getAdapter()).getFilter().filter((CharSequence)newText);
        }
        return false;
    }

    public static interface OnItemSelectedListener<T>
    extends Serializable {
        public void onItemSelected(T var1, int var2);
    }
}

