package com.xdja.jxlsclient.bean.clientlogin;

import com.xdja.jxlsclient.bean.common.ReportLogBean;
import com.xdja.jxlsclient.enums.BizModuleEnum;
import com.xdja.jxlsclient.enums.LogTypeEnum;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName：SimpClientLoginReportBean
 * @Description：客户端登陆登出上报日志bean
 * @author: wrf
 * @date: 2019/8/19/019 14:06
 * @version: V1.0
 */
public class ClientLoginReportBean extends ReportLogBean {
    private static final Logger logger = LoggerFactory.getLogger(ClientLoginReportBean.class);

    /**
     * 用户id
     */
    private String userId;
    /**
     * 账号
     */
    private String policeId;
    /**
     * identifier
     */
    private String identifier;
    /**
     * 客户端类型, 1001 android 1003 pc
     */
    private String clientType;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPoliceId() {
        return policeId;
    }

    public void setPoliceId(String policeId) {
        this.policeId = policeId;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setLogType(LogTypeEnum.ClientLoginEnum clientLoginEnum) throws JxlsClientException {
        if (null == clientLoginEnum) {
            throw new JxlsClientException("clientLoginEnum类不能为空");
        }
        setLogType(clientLoginEnum.getCode());
    }

    @Override
    public void checkParam() throws JxlsClientException{
        super.checkParam();

        //userId
        String userId = this.userId;
        if (CommonUtil.isEmpty(userId)) {
            logger.error("userId属性值不能为空");
            throw new JxlsClientException("userId属性值不能为空");
        }
        //clientType
        String clientType = this.clientType;
        if (CommonUtil.isEmpty(clientType)) {
            logger.error("clientType属性值不能为空");
            throw new JxlsClientException("clientType属性值不能为空");
        }
    }

    @Override
    public void initParam() {
        super.initParam();
        this.setBizModule(BizModuleEnum.clientLogin.getCode());
        this.setRoutingKey(BizModuleEnum.clientLogin.getCode());
        if (! CommonUtil.isEmpty(getSystemName())) {
            this.setRoutingKey(getSystemName() + "." + BizModuleEnum.clientLogin.getCode());
        }
    }
}
