package com.xdja.jxlsclient.bean.common;

import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName：ReportCommonInfoBean
 * @Description：上报通用基本信息bean
 * @author: wrf
 * @date: 2019/8/16/016 15:58
 * @version: V1.0
 */
public abstract class ReportLogBean {
    private static final Logger logger = LoggerFactory.getLogger(ReportLogBean.class);

    /**
     * 成功，1
     */
    public static final int EXCEPTION_FLAG_TRUE_1 = 1;
    /**
     * 失败，2
     */
    public static final int EXCEPTION_FLAG_FAIL_2 = 2;

    /**
     * 毫秒。业务开始时间
     */
    private Long startTime;
    /**
     * 毫秒。业务结束时间
     */
    private Long endTime;
    /**
     * 所属子系统,从枚举类{@link com.xdja.jxlsclient.enums.SystemNameEnum}中获取
     */
    private String systemName;
    /**
     * 业务模块,从枚举类{@link com.xdja.jxlsclient.enums.BizModuleEnum} 中获取
     */
    private String bizModule;
    /**
     * 本机IP
     */
    private String ip;
    /**
     * 耗时
     * 毫秒。上报客户端计算
     */
    private int duration;
    /**
     * 业务成功或失败，不是异常
     */
    private Boolean result;
    /**
     * 日志类型,从枚举类{@link com.xdja.jxlsclient.enums.LogTypeEnum}中获取
     */
    private Integer logType;
    /**
     * 上报客户端计算。1是 2否
     */
    private Integer exceptionFlag;

    /**
     * 错误信息
     */
    private String errorStr;
    /**
     * 请求业务bean
     */
    private ReportBaseRequestBean request = new ReportBaseRequestBean();
    /**
     * 响应业务bean
     */
    private ReportBaseResponseBean response = new ReportBaseResponseBean();

    /**
     * 路由key
     */
    private String routingKey;

    /**
     * @Description: 参数校验
     * @author wrf
     * @Date 2019-08-20 15:42
     * @param
     * @return
    */
    protected void checkParam() throws JxlsClientException {
        //result
        Boolean result = this.getResult();
        if (null == result) {
            logger.error("result属性值不正确");
            throw new JxlsClientException("result属性值不正确");
        }
        //startTime
        Long startTime = this.getStartTime();
        if (null == startTime) {
            logger.error("startTime属性值不能为空");
            throw new JxlsClientException("startTime属性值不能为空");
        }
        //endTime
        Long endTime = this.getEndTime();
        if (null == endTime) {
            logger.error("endTime属性值不能为空");
            throw new JxlsClientException("endTime属性值不能为空");
        }
    }

    /**
     * @Description: 初始化参数
     * @author wrf
     * @Date 2019-08-20 15:43
     * @param
     * @return
    */
    protected void initParam() {
        //1.初始化参数
        this.setSystemName(Consts.systemName);
        this.setIp(CommonUtil.getLocalIpAddress());
        this.setExceptionFlag(! CommonUtil.isEmpty(this.getErrorStr()) ? ReportLogBean.EXCEPTION_FLAG_TRUE_1 : ReportLogBean.EXCEPTION_FLAG_FAIL_2);
        if (null != this.getStartTime() && null != this.getEndTime()) {
            this.setDuration((int)(this.getEndTime() - this.getStartTime()));
        }
    }


    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getSystemName() {
        return systemName;
    }

    protected void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getBizModule() {
        return bizModule;
    }

    protected void setBizModule(String bizModule) {
        this.bizModule = bizModule;
    }

    public String getIp() {
        return ip;
    }

    protected void setIp(String ip) {
        this.ip = ip;
    }

    public int getDuration() {
        return duration;
    }

    protected void setDuration(int duration) {
        this.duration = duration;
    }

    public Boolean getResult() {
        return result;
    }

    public void setResult(Boolean result) {
        this.result = result;
    }

    public Integer getLogType() {
        return logType;
    }

    public void setLogType(Integer logType) {
        this.logType = logType;
    }

    public Integer getExceptionFlag() {
        return exceptionFlag;
    }

    protected void setExceptionFlag(Integer exceptionFlag) {
        this.exceptionFlag = exceptionFlag;
    }

    public String getErrorStr() {
        return errorStr;
    }

    public void setErrorStr(String errorStr) {
        this.errorStr = errorStr;
    }

    public ReportBaseRequestBean getRequest() {
        return request;
    }

    public void setRequest(ReportBaseRequestBean request) {
        this.request = request;
    }

    public ReportBaseResponseBean getResponse() {
        return response;
    }

    public void setResponse(ReportBaseResponseBean response) {
        this.response = response;
    }

    public String getRoutingKey() {
        return routingKey;
    }

    protected void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }
}
