package com.xdja.jxlsclient.bean.fileupload;

import com.xdja.jxlsclient.bean.common.ReportLogBean;
import com.xdja.jxlsclient.enums.BizModuleEnum;
import com.xdja.jxlsclient.enums.LogTypeEnum;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName：FileUploadReportBean
 * @Description：上传文件到服务器日志bean
 * @author: wrf
 * @date: 2019/9/2/002 15:21
 * @version: V1.0
 */
public class FileUploadReportBean extends ReportLogBean {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadReportBean.class);

    public FileUploadReportBean() {
        this.fileStatus = "1";
    }

    /**
     * 文件id
     */
    private String fileId;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 文件扩展名
     */
    private String extName;
    /**
     * 文件大小
     */
    private String fileSize;
    /**
     * 业务类型
     */
    private String bizType;
    /**
     * 业务id
     */
    private String bizId;
    /**
     * 文件状态
     */
    private String fileStatus;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getExtName() {
        return extName;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }

    public String getFileSize() {
        return fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getFileStatus() {
        return fileStatus;
    }

    protected void setFileStatus(String fileStatus) {
        this.fileStatus = fileStatus;
    }

    public void setLogType(LogTypeEnum.FileUploadEnum fileUploadEnum) throws JxlsClientException {
        if (null == fileUploadEnum) {
            throw new JxlsClientException("fileUploadEnum类不能为空");
        }
        setLogType(fileUploadEnum.getCode());
    }

    @Override
    public void checkParam() throws JxlsClientException{
        super.checkParam();

        //userId
        String fileId = this.fileId;
        if (CommonUtil.isEmpty(fileId)) {
            logger.error("fileId属性值不能为空");
            throw new JxlsClientException("fileId属性值不能为空");
        }
    }

    @Override
    public void initParam() {
        super.initParam();
        this.setBizModule(BizModuleEnum.fileUpload.getCode());
        this.setRoutingKey(BizModuleEnum.fileUpload.getCode());
        if (! CommonUtil.isEmpty(getSystemName())) {
            this.setRoutingKey(getSystemName() + "." + BizModuleEnum.fileUpload.getCode());
        }
    }
}
