package com.xdja.jxlsclient.enums;

/**
 * @ClassName：LogTypeEnum
 * @Description: 日志类型枚举类
 * @author: wrf
 * @date: 2019/8/16/016 16:03
 * @version: V1.0
 */
public class LogTypeEnum {

    /**
     * @ClassName：ClientLoginEnum
     * @Description：客户端登陆登出日志类型
     * @author: wrf
     * @date: 2019/8/20/020 8:45
     * @version: V1.0
     *
     */
    public enum ClientLoginEnum{
        /**
         * 日志类型,客户端登陆(1101)
         */
        CLIENT_LOGIN(1101, "客户端登陆"),
        /**
         * 日志类型,客户端登出(1102)
         */
        CLIENT_LOGOUT(1102, "客户端登出")

        ;

        ClientLoginEnum(){}

       ClientLoginEnum(Integer code, String desc) {
           this.code = code;
           this.desc = desc;
       }

       /**
        * @Description: 检测日志类型的合法性
        * @author wrf
        * @Date 2019-08-19 16:21
        * @param logType 日志类型
        * @return
        */
      /* public static boolean checkClientLoginLogType(Integer logType) {
           ClientLoginEnum[] logTypeEnum = getClientLoginLogTypeEnum();
           for (ClientLoginEnum typeEnum : logTypeEnum) {
               if (typeEnum.getCode().equals(logType)) {
                   return true;
               }
           }
           return false;
       }*/

       /**
        * @Description: 获取所有的日志类型
        * @author wrf
        * @Date 2019-08-19 16:21
        * @param
        * @return
        */
     /*  public static ClientLoginEnum[] getClientLoginLogTypeEnum() {
           return ClientLoginEnum.values();
       }*/

       /**
        * 日志类型，code
        */
       private Integer code;
       /**
        * 日志类型，desc
        */
       private String desc;

       public Integer getCode() {
           return code;
       }

       public void setCode(Integer code) {
           this.code = code;
       }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * @ClassName：ClientLoginEnum
     * @Description：客户端登陆登出日志类型
     * @author: wrf
     * @date: 2019/8/20/020 8:45
     * @version: V1.0
     *
     */
    public enum FileUploadEnum{
        /**
         * 日志类型,上传文件日志(1109)
         */
        FILE_UPLOAD(1109, "上传文件日志")

        ;

        FileUploadEnum(){}

        FileUploadEnum(Integer code, String desc) {
           this.code = code;
           this.desc = desc;
       }

       /**
        * 日志类型，code
        */
       private Integer code;
       /**
        * 日志类型，desc
        */
       private String desc;

       public Integer getCode() {
           return code;
       }

       public void setCode(Integer code) {
           this.code = code;
       }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

}
