package com.xdja.jxlsclient.handler;

import com.xdja.jxlsclient.bean.clientlogin.ClientLoginReportBean;
import com.xdja.jxlsclient.bean.common.ReportLogBean;
import com.xdja.jxlsclient.exception.JxlsClientException;
import com.xdja.jxlsclient.util.JsonUtil;
import com.xdja.jxlsclient.util.SendMsgToRabbitMqUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName：SimpClientLoginReportLogHandler
 * @Description：simp 登陆登出日志上报处理类
 * @author: wrf
 * @date: 2019/8/19/019 16:48
 * @version: V1.0
 */
public class ClientLoginReportLogHandler extends AbstractReportLogHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClientLoginReportLogHandler.class);

    @Override
    public void handler(ReportLogBean reportLogBean) throws JxlsClientException {
        try {
            ClientLoginReportBean clientLoginReportBean = (ClientLoginReportBean)reportLogBean;
            logger.debug("simp上报RabbitMq登陆日志>>>ClientLoginReportBean: 【{}】", JsonUtil.toJson(clientLoginReportBean));
            //1、检测参数
            clientLoginReportBean.checkParam();
            //2、封装计算信息
            clientLoginReportBean.initParam();
            //3、发送消息到RabbitMq
            SendMsgToRabbitMqUtil.sendMessage(clientLoginReportBean.getRoutingKey(), JsonUtil.toJson(clientLoginReportBean));
            logger.debug("simp上报RabbitMq登陆日志<<<");
        }catch (Exception e) {
            logger.error("simp上报登陆登出日志失败: ", e);
        }
    }

}
